package com.rv.component.dialog;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.ruiwenliu.wrapper.dialog.BaseDialog;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.rv.component.control.CircleNumberProgressBar;

/**
 * 温馨提示
 */
public class DownloadLoadingDialog extends BaseDialog {
    TextView tv;
    CircleNumberProgressBar pb;

    public DownloadLoadingDialog(@NonNull Context context) {
        super(context);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
    }

    @Override
    public void helper(ViewHolder helper) {
        super.helper(helper);
        tv = (TextView) helper.getView(R.id.rv_hint);
        pb = (CircleNumberProgressBar) helper.getView(R.id.pb_load);
    }

    @Override
    public int getViewLayout() {
        return R.layout.dialog_download_loading;
    }

    public void setContent(int percentage) {
        if (tv != null) {
            pb.setProgress(percentage);
            if (percentage == 100) {
                pb.setVisibility(View.GONE);
                tv.setText("已保存到相册，快去分享吧！");
            }
        }
    }
}
