package com.base.utils.receive;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.base.utils.tools.android.LogUtil;
import com.base.utils.tools.android.NotificationUtil;

/**
 * 接收通知栏消息事件的广播
 */
public class NotificationBroadcastReceiver extends BroadcastReceiver {


    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        int type = intent.getIntExtra(NotificationUtil.TYPE, -1);   //得到notifyId
        LogUtil.w(NotificationBroadcastReceiver.class, "type：" + type);
        if (action.equals(NotificationUtil.NOTIFICATION_ACTION_CLICK)) {
            //处理点击事件
            LogUtil.w(NotificationBroadcastReceiver.class, "点击了通知消息");
        } else if (action.equals(NotificationUtil.NOTIFICATION_ACTION_DELETE)) {
            //处理滑动清除和点击删除事件
            LogUtil.w(NotificationBroadcastReceiver.class, "清除了通知消息");
        }
    }
}
