package com.ruiwenliu.wrapper.browse;

import android.os.Bundle;
import android.support.annotation.IntegerRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.baidu.mapapi.model.LatLng;
import com.base.utils.base.BaseFragment;
import com.base.utils.ui.image.pinch.PinchImageView;
import com.ruiwenliu.wrapper.R;
import com.ruiwenliu.wrapper.dialog.BottomPromptTwoDialog;
import com.ruiwenliu.wrapper.util.ImageFileUtil;
import com.ruiwenliu.wrapper.util.MapUtil;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.component.utils.LocationRecord;

import java.util.Objects;

/**
 * 浏览图片的碎片
 * FragmentImageBrowse
 */

public class FragmentImageBrowse extends BaseFragment {
    final private static String KEY_IMAGE_INT = "image_int";
    final private static String KEY_IMAGE_STRING = "image_string";

    private int getImageInt() {
        if (getArguments() == null) return 0;
        return getArguments().getInt(FragmentImageBrowse.KEY_IMAGE_INT);
    }

    private String getImageString() {
        if (getArguments() == null) return "";
        return getArguments().getString(FragmentImageBrowse.KEY_IMAGE_STRING);
    }

    public static FragmentImageBrowse getInstance(@IntegerRes int imageRes) {
        FragmentImageBrowse instance = new FragmentImageBrowse();
        Bundle bundle = new Bundle();
        bundle.putInt(FragmentImageBrowse.KEY_IMAGE_INT, imageRes);
        instance.setArguments(bundle);
        return instance;
    }

    public static FragmentImageBrowse getInstance(String imageUrl) {
        FragmentImageBrowse instance = new FragmentImageBrowse();
        Bundle bundle = new Bundle();
        bundle.putString(FragmentImageBrowse.KEY_IMAGE_STRING, imageUrl);
        instance.setArguments(bundle);
        return instance;
    }

    PinchImageView pinchImageView;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_image_browse, container, false);
        pinchImageView = view.findViewById(R.id.image_browse_pinch_image_view);
        onData();
        return view;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        onView();
    }

    @Override
    public void onData() {
    }

    @Override
    public void onView() {
        if (getImageInt() != 0) {
            pinchImageView.setImageResource(getImageInt());
        } else {
            GlideManager.getInstance(baseContext).loadImage(getImageString(), pinchImageView);
        }
        pinchImageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (Objects.requireNonNull(getActivity()) != null)
                    Objects.requireNonNull(getActivity()).finish();

            }
        });
    }
}
