package com.xxfc.rv;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;

import com.alibaba.android.arouter.launcher.ARouter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.dialog.BaseDialog;
import com.rv.home.rv.module.ApiConfig;

public class PrivacyFirstTipsDialog extends BaseDialog {

    public PrivacyFirstTipsDialog(@NonNull Context context) {
        super(context);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
    }

    public PrivacyFirstTipsDialog(Context context, int themeResId) {
        super(context, themeResId);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
    }

    @Override
    public int getViewLayout() {
        return R.layout.dialog_privacy_first_tips;
    }

    public static class Builder {

        private Context mContext;
        private Button btnDisagree, btnAgree;
        private TextView txtContent;
        private PrivacyFirstTipsDialog dialog;
        private PrivacyListener mListener;

        public Builder(Context context, PrivacyListener listener) {
            mContext = context;
            this.mListener = listener;
        }

        public interface DownloadListener {
            void download();
        }

        public Builder show() {
            final PrivacyFirstTipsDialog dialog = create();
            dialog.show();
            return this;
        }

        /**
         * 创建定制的对话框
         */
        public PrivacyFirstTipsDialog create() {
            LayoutInflater inflater = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            dialog = new PrivacyFirstTipsDialog(mContext, R.style.DialogActivityTheme);
            // 获取对话框的布局
            View layout = inflater.inflate(R.layout.dialog_privacy_first_tips, null);
            // 为对话框添加布局和设置大小
            dialog.addContentView(layout, new WindowManager.LayoutParams(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT));
            txtContent = layout.findViewById(R.id.tv_tips_content) ;
            this.btnDisagree = layout.findViewById(R.id.btn_disagree);
            this.btnAgree = layout.findViewById(R.id.btn_agree);
            this.btnAgree.setOnClickListener(v -> {
                if (mListener != null) mListener.agree();
                dialog.dismiss();
            });

            this.btnDisagree.setOnClickListener(v -> {
                if (mListener != null) mListener.disAgree();
                dialog.dismiss();
            });

            SpannableStringBuilder ssb = new SpannableStringBuilder();
            String str = txtContent.getText().toString().trim();
            ssb.append(str);
            final int start = str.indexOf("《隐私政策》");//第一个出现的位
            ssb.setSpan(new ClickableSpan() {

                @Override
                public void onClick(View widget) {
                    avoidHintColor(widget);
                    ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                            .withString("title", "隐私政策")
                            .withString("url", ApiConfig.HTTP_URL_CAR_TYPE_NOTICE)
                            .withInt("type", 19)
                            .navigation();
                }

                @Override
                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(mContext.getResources().getColor(R.color.gray_FFB74B));       //设置文件颜色
                    // 去掉下划线
                    ds.setUnderlineText(false);
                }

            }, start, start + 6, 0);
            final int end = str.lastIndexOf("《隐私政策》");//最后一个出现的位置
            ssb.setSpan(new ClickableSpan() {

                @Override
                public void onClick(View widget) {
                    avoidHintColor(widget);
                    ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                            .withString("title", "隐私政策")
                            .withString("url", ApiConfig.HTTP_URL_CAR_TYPE_NOTICE)
                            .withInt("type", 19)
                            .navigation();

                }

                @Override
                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(mContext.getResources().getColor(R.color.gray_FFB74B));       //设置文件颜色
                    // 去掉下划线
                    ds.setUnderlineText(false);
                }

            }, end, end + 6, 0);

            final int startUser = str.indexOf("《用户协议》");//第一个出现的位
            ssb.setSpan(new ClickableSpan() {

                @Override
                public void onClick(View widget) {
                    avoidHintColor(widget);
                    ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                            .withString("title", "用户协议")
                            .withString("url", ApiConfig.HTTP_URL_CAR_TYPE_NOTICE)
                            .withInt("type", 15)
                            .navigation();
                }

                @Override
                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(mContext.getResources().getColor(R.color.gray_FFB74B));       //设置文件颜色
                    // 去掉下划线
                    ds.setUnderlineText(false);
                }

            }, startUser, startUser + 6, 0);
            final int endUser = str.lastIndexOf("《用户协议》");//最后一个出现的位置
            ssb.setSpan(new ClickableSpan() {

                @Override
                public void onClick(View widget) {
                    avoidHintColor(widget);

                    ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                            .withString("title", "用户协议")
                            .withString("url", ApiConfig.HTTP_URL_CAR_TYPE_NOTICE)
                            .withInt("type", 15)
                            .navigation();

                }

                @Override
                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(mContext.getResources().getColor(R.color.gray_FFB74B));       //设置文件颜色
                    // 去掉下划线
                    ds.setUnderlineText(false);
                }

            }, endUser, endUser + 6, 0);

            txtContent.setMovementMethod(LinkMovementMethod.getInstance());
            txtContent.setText(ssb, TextView.BufferType.SPANNABLE);
            dialog.setCancelable(false);
            dialog.setContentView(layout);
            return dialog;
        }

        private void avoidHintColor(View view) {
            if (view instanceof TextView)
                ((TextView) view).setHighlightColor(mContext.getResources().getColor(android.R.color.transparent));
        }
    }




    public interface PrivacyListener {

        void agree();

        void disAgree();
    }

}
