package com.rv.tourism.adapter;

import android.view.View;
import android.widget.ImageView;

import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.tourism.R;
import com.rv.tourism.bean.BeanTourAround;
import com.rv.tourism.bean.BeanVisitorInformation;

/**
 * 出游人信息 adapter
 */
public class VisitorInformationAdapter extends BaseQuickAdapter<BeanVisitorInformation, BaseViewHolder> {
    public VisitorInformationAdapter() {
        super(R.layout.rv_item_visitor_information);
    }

    @Override
    protected void convert(BaseViewHolder helper, BeanVisitorInformation item) {
        if ("0".equals(item.getIsChild())) {
            helper.setText(R.id.tv_people_type, "成人");
        }else {
            helper.setText(R.id.tv_people_type, "儿童");
        }

        helper.setText(R.id.tv_name,item.getName());
        helper.setText(R.id.tv_phone,item.getPhone());
        if (TextUtil.isEmpty(item.getIdCard())) {
            helper.setVisible(R.id.tv_idcard_title,false);
        }else {
            helper.setText(R.id.tv_idcard, item.getIdCard());
            helper.setVisible(R.id.tv_idcard_title,true);
        }
    }
}
