package com.rv.tourism;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.base.utils.tools.android.IntentUtil;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.browse.ActivityImageBrowseUrl;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.tourism.adapter.AllPopularAdapter;
import com.rv.tourism.adapter.PopularBrigadeAdapter;
import com.rv.tourism.adapter.TourAroundAdapter;
import com.rv.tourism.api.TourismApi;
import com.rv.tourism.bean.BeanPopularBrigade;
import com.rv.tourism.bean.BeanTourAround;
import com.rv.tourism.bean.BeanTourismBanner;
import com.rv.tourism.other.PopularTourListActivity;
import com.rv.tourism.other.TravelDetailsActivity;
import com.rv.tourism.presenter.TourismPresenter;
import com.yuyife.banner.Banner;
import com.yuyife.banner.BannerConfig;
import com.yuyife.banner.listener.OnBannerListener;
import com.yuyife.banner.loader.ImageLoader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

/**
 * 旅游
 */
public class TourismFragment extends BaseFragment<TourismPresenter> implements BaseQuickAdapter.RequestLoadMoreListener {

    @BindView(R2.id.travel_city_text)
    TextView travelCityText;
    @BindView(R2.id.search_input)
    TextView searchInput;
    @BindView(R2.id.travel_banner)
    Banner travelBanner;
    @BindView(R2.id.rv_popular_brigade)
    RecyclerView rvPopularBrigade;
    @BindView(R2.id.rv_tour_around)
    RecyclerView rvTourAround;
    @BindView(R2.id.rv_popular_more)
    RecyclerView rvPopularMore;
    @BindView(R2.id.travel_hot_more_close)
    ImageView travelHotMoreClose;
    @BindView(R2.id.ll_layout_popular_more)
    LinearLayout llLayoutPopularMore;


    private ArrayList<String> images = new ArrayList<>();    //图片(默认采用网络地址)
    private List<String> titles = new ArrayList<>();         //图片标题

    private PopularBrigadeAdapter mPopularBrigadeAdapter;
    private TourAroundAdapter mTourAroundAdapter;
    private AllPopularAdapter mAllPopularAdapter;
    private int mPage;
    private int countPage;


    public static TourismFragment getInstance(int type) {
        Bundle bundl = new Bundle();
        bundl.putInt("type", type);
        TourismFragment fragment = new TourismFragment();
        fragment.setArguments(bundl);
        return fragment;
    }

    @Override
    public int getViewLayout() {
        return R.layout.activity_tourism;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        setBanner();

        //热门游
        mPopularBrigadeAdapter = new PopularBrigadeAdapter();
        rvPopularBrigade.setLayoutManager(new LinearLayoutManager(_mActivity, LinearLayoutManager.HORIZONTAL, false));
        rvPopularBrigade.addItemDecoration(new AbSpacesItemDecoration(5));// 分割线。
        rvPopularBrigade.setNestedScrollingEnabled(false);
        rvPopularBrigade.setAdapter(mPopularBrigadeAdapter);

        //全部热门旅游
        mAllPopularAdapter = new AllPopularAdapter();
        rvPopularMore.setLayoutManager(new GridLayoutManager(_mActivity, 3));
        rvPopularMore.addItemDecoration(new AbSpacesItemDecoration(23));// 分割线。
        rvPopularMore.setNestedScrollingEnabled(false);
        rvPopularMore.setAdapter(mAllPopularAdapter);


        //周边游
        mTourAroundAdapter = new TourAroundAdapter();
        rvTourAround.setLayoutManager(new LinearLayoutManager(_mActivity, LinearLayoutManager.VERTICAL, false));
        rvTourAround.setAdapter(mTourAroundAdapter);

        mPopularBrigadeAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                BeanPopularBrigade.DataBean dataBean = (BeanPopularBrigade.DataBean) adapter.getItem(position);
                startActivity(PopularTourListActivity.getIntent(_mActivity,dataBean.getName(),dataBean.getId()));
            }
        });

        mAllPopularAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                BeanPopularBrigade.DataBean item = (BeanPopularBrigade.DataBean) adapter.getItem(position);
                startActivity(PopularTourListActivity.getIntent(_mActivity,item.getName(),item.getId()));
                llLayoutPopularMore.setVisibility(View.GONE);
            }
        });

        mTourAroundAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                BeanTourAround.DataBeanX.DataBean dataBean = (BeanTourAround.DataBeanX.DataBean) adapter.getItem(position);
                startActivity(TravelDetailsActivity.getIntent(_mActivity,dataBean));
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState) {
        loadBannerData();
        loadPopularBrigadeData();
        loadTourAroundData();
    }


    @OnClick({R2.id.travel_city_layout, R2.id.travel_server_image, R2.id.ll_item_popular_brigade_many, R2.id.travel_hot_more_close})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.travel_city_layout) {

        } else if (id == R.id.travel_server_image) {

        } else if (id == R.id.ll_item_popular_brigade_many) {
            //查看热门更多
            llLayoutPopularMore.setVisibility(View.VISIBLE);
        } else if (id == R.id.travel_hot_more_close) {
            llLayoutPopularMore.setVisibility(View.GONE);
        }
    }


    /**
     * 获取周边游
     */
    private void loadTourAroundData() {
        mPage = 1;
        getLoadTourAroundData(mPage);
    }

    private void getLoadTourAroundData(int page) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("tagId", "");
        map.put("query", "");
        map.put("page", page);
        map.put("limit", "10");
        map.put("latitudel", "22.954205");
        map.put("longitude", "113.879421");
        mPresenter.getData(2, TourismApi.QUERY_RIM_LIST, BeanTourAround.class, map, false);
    }

    /**
     * 获取热门
     */
    private void loadPopularBrigadeData() {
        HashMap<String, String> map = new HashMap<>();
        map.put("hot", "1");
        map.put("page", "1");
        map.put("limit", "50");
        mPresenter.getData(1, TourismApi.QUERY_HOT_LIST, BeanPopularBrigade.class, map, false);
    }

    /**
     * 获取轮播图
     */
    private void loadBannerData() {
        HashMap<String, String> map = new HashMap<>();
        map.put("type", "1");
        mPresenter.getData(0, TourismApi.QUERY_BANNER_MAIN, BeanTourismBanner.class, map, false);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                bannerData((BeanTourismBanner) result);
                break;
            case 1:
                popularBrigade((BeanPopularBrigade) result);
                break;
            case 2:
                tourAround((BeanTourAround) result);
                break;
        }
    }

    private void tourAround(BeanTourAround bean) {
        if (mPage == 1) {
            if (bean.getData().getTotalCount() == 0) {
//                mTourAroundAdapter.setEmptyView(getEmptyView(recyclerView, -1, mActivity.getString(R.string.rv_driving_data_null)));
                return;
            }

            countPage = bean.getData().getTotalPage();
            mTourAroundAdapter.addNewData(bean);
            mTourAroundAdapter.loadMoreComplete();
        } else {
            mTourAroundAdapter.addData(bean.getData().getData());
            mTourAroundAdapter.loadMoreComplete();
        }
    }


    private void popularBrigade(BeanPopularBrigade result) {
        mPopularBrigadeAdapter.addData(result.getData());
        mAllPopularAdapter.addData(result.getData());
    }


    private void bannerData(BeanTourismBanner data) {
        if (data != null) {
            titles.clear();
            images.clear();
            for (int i = 0; i < data.getData().size(); i++) {
                images.add(data.getData().get(i).getCover());
                titles.add("");
            }
        }
        setBanner();
    }


    /**
     * 设置轮番图
     */
    private void setBanner() {
        travelBanner.isAutoPlay(true)
                .setBannerTitles(titles)
                .setImages(images)
                .setDelayTime(3000)
                .setImageLoader(new ImageLoader() {
                    @Override
                    public void displayImage(Context context, Object path, ImageView imageView) {

                        GlideManager.getInstance(context).loadImage(String.valueOf(path), imageView);
                    }
                })
                .setOnBannerListener(new OnBannerListener() {
                    @Override
                    public void OnBannerClick(int position) {
                        Bundle bundle = new Bundle();
                        bundle.putInt(ActivityImageBrowseUrl.KEY_BACKGROUND, R.color.colorPrimary);
                        bundle.putStringArrayList(ActivityImageBrowseUrl.KEY_IMAGE, (ArrayList<String>) images);
                        IntentUtil.startActivity(_mActivity, ActivityImageBrowseUrl.class, bundle);

                    }
                })
                .start();

        travelBanner.updateBannerStyle(BannerConfig.CIRCLE_INDICATOR);
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
//        if (ModuleEventUtil.getOnModuleEventListener() != null) {
//            ModuleEventUtil.getOnModuleEventListener().onClear();
//        }
    }



    @Override
    public void onLoadMoreRequested() {
        if (mPage >= countPage) {
            mTourAroundAdapter.loadMoreEnd();
        } else {
            mPage++;
            getLoadTourAroundData(mPage);
        }
    }


    public class AbSpacesItemDecoration extends RecyclerView.ItemDecoration {

        private int space;

        public AbSpacesItemDecoration(int space) {
            this.space = space;
        }

        @Override
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            outRect.left = space;
            outRect.right = space;
            outRect.bottom = space;
            //注释这两行是为了上下间距相同
//        if(parent.getChildAdapterPosition(view)==0){
            outRect.top = space;
        }
    }
}
