package com.rv.rvmine.adapter;

import android.widget.CompoundButton;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.rvmine.R;
import com.rv.rvmine.bean.TravelerListBean;

import java.util.ArrayList;
import java.util.List;

/**
 * Desc:出游人列表
 */

public class TravelerListAdapter extends BaseQuickAdapter<TravelerListBean.DataBean, BaseViewHolder> {
    public TravelerListAdapter() {
        super(R.layout.rv_item_traveler_list);
    }
    @Override
    protected void convert(BaseViewHolder helper, final TravelerListBean.DataBean item) {
        helper.setText(R.id.tv_name, item.getName());
        helper.setText(R.id.tv_phone, item.getPhone());
        helper.setText(R.id.tv_id_card, item.getIdCard());
        helper.addOnClickListener(R.id.tv_edit);
        helper.setOnCheckedChangeListener(R.id.cb_draveler, new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
              int position =getPosition(item);
              setItemState(isChecked, position);

            }
        });
    }

    public int getPosition(TravelerListBean.DataBean item){
        return mData.indexOf(item);
    }

    /**
     * 设置出游人选中状态
     * @param check
     * @param position
     */
    public void setItemState(boolean check,int position){
        mData.get(position).selectType=check==true?1:0;
        notifyItemChanged(position);
    }

    /**
     * 获取选中的出游人数据
     * @return
     */
    public List<TravelerListBean.DataBean> getSelectItem(){
        List<TravelerListBean.DataBean>  list=new ArrayList<>();
       for (TravelerListBean.DataBean dataBean:mData){
           if(dataBean.selectType==1){
               list.add(dataBean);
           }
       }
        return list;
    }

}
