package com.rv.home.rv.module.ui.main.home.dialog;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.dialog.BasePopupWindow;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ui.main.home.adapter.CarAttributeAdapter;
import com.rv.home.rv.module.ui.main.home.adapter.OrderPriceDetailAdapter;
import com.rv.home.rv.module.ui.main.home.bean.CarAttributeListBean;
import com.rv.home.rv.module.ui.main.home.bean.OrderPriceDetailBean;

import java.util.List;

/**
 * Created :Auser
 * Date: 2019/5/31.
 * Desc:订单价格明细
 */

public class OrderPriceDetailPw extends BasePopupWindow{

    private OrderPriceDetailAdapter detailAdapter;
    private TextView tvTitle;
    public OrderPriceDetailPw(@NonNull Activity activity) {
        super(activity);
        setClippingEnabled(true);
        setOutsideTouchable(true);
        setFocusable(true);
        setHeight(ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    @Override
    public int getViewLayout() {
        return R.layout.rv_pw_order_price_detail;
    }

    @Override
    public void helper(ViewHolder helper) {
        super.helper(helper);

        tvTitle=helper.getView(R.id.tv_title);
        RecyclerView recyclerView = helper.getView(R.id.recyclerView);
        recyclerView.setLayoutManager(new LinearLayoutManager(getDialogContext()));
        detailAdapter = new OrderPriceDetailAdapter();
        recyclerView.setAdapter(detailAdapter);
    }

    public void setNewData(OrderPriceDetailBean bean) {
        if (detailAdapter != null && bean != null) {
            tvTitle.setText(bean.getKey());
            detailAdapter.setNewData(bean.getChildren());
        }
    }




//    @Override
//    public void showAsDropDown(View parent, int xoff, int yoff, int gravity) {
//        if (Build.VERSION.SDK_INT >= 24) {
//            Rect visibleFrame = new Rect();
//            parent.getGlobalVisibleRect(visibleFrame);
//            int height = parent.getResources().getDisplayMetrics().heightPixels - visibleFrame.bottom;
////            int height = anchor.getResources().getDisplayMetrics().heightPixels;
//            setHeight(height);
//        }
//        super.showAsDropDown(parent, xoff, yoff, gravity);
//    }
}
