package com.rv.home.rv.module.ui.main.adapter;

import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.view.ViewGroup;

import com.ruiwenliu.wrapper.base.BaseWrapperFragment;

import java.util.List;

/**
 * Created by Administrator on 2019/5/5.
 */

public class TabAdapter<T extends BaseWrapperFragment> extends FragmentPagerAdapter {
    private int position;

    private List<T> list;

    public TabAdapter(FragmentManager fm, List<T> list) {
        super(fm);
        this.list = list;
    }

    public T getCurrentFragment() {
        return list.get(position);
    }

    @Override
    public T getItem(int i) {
        return list.get(i);
    }

    @Override
    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        super.setPrimaryItem(container, position, object);
        this.position = position;
    }


    @Override
    public int getCount() {
        return list == null ? 0 : list.size();
    }

    @Override
    public int getItemPosition(Object object) {
        return PagerAdapter.POSITION_NONE;
    }

    /**
     * 刷新新数据
     */
    public void refreshData(List<T> listFragment){
        list.clear();
        list=listFragment;
        notifyDataSetChanged();
    }
}
