package com.rv.camp;

import android.graphics.Rect;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.rv.camp.adapter.CampListAdapter;
import com.rv.camp.adapter.CampTypeListAdapter;
import com.rv.camp.api.CampApi;
import com.rv.camp.bean.CampListBean;
import com.rv.camp.bean.CampTypeBean;
import com.rv.camp.camp.CampDetailActivity;
import com.rv.camp.presenter.CampPresenter;

import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.OnClick;

/**
 * 营地
 */
public class CampFragment extends BaseFragment<CampPresenter> implements BaseQuickAdapter.RequestLoadMoreListener{

    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.rv_type)
    RecyclerView rvType;
    @BindView(R2.id.v_shadow)
    View vShadow;

    private boolean isOpen = true;
    private CampListAdapter campAdapter;
    private CampTypeListAdapter campTypeListAdapter;
    private int mPage;
    private int countPage;
    private String type =null;


    public static CampFragment getInstance(int type) {
        Bundle bundl = new Bundle();
        bundl.putInt("type", type);
        CampFragment fragment = new CampFragment();
        fragment.setArguments(bundl);
        return fragment;
    }


    @Override
    public int getViewLayout() {
        return R.layout.activity_camp;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        campAdapter = new CampListAdapter();
        rvContent.setLayoutManager(new GridLayoutManager(_mActivity, 2));
        rvContent.addItemDecoration(new AbSpacesItemDecoration(15));// 分割线。
        rvContent.setNestedScrollingEnabled(false);
        rvContent.setAdapter(campAdapter);

        campTypeListAdapter = new CampTypeListAdapter();
        rvType.setLayoutManager(new LinearLayoutManager(_mActivity, LinearLayoutManager.VERTICAL, false));
        rvType.setAdapter(campTypeListAdapter);

        campTypeListAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                CampTypeBean.DataBean item = (CampTypeBean.DataBean) adapter.getItem(position);
                type = item.getId();
                onRefresh();
                rvType.setVisibility(View.GONE);
                vShadow.setVisibility(View.GONE);
                isOpen = true;
                campTypeListAdapter.setSelectPosition(position);
            }
        });

        campAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                CampListBean.DataBeanX.DataBean item = (CampListBean.DataBeanX.DataBean) adapter.getItem(position);
                startActivity(CampDetailActivity.getIntent(_mActivity,item));
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState) {
        onRefresh();
        getCampTypeList();
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                processData((CampListBean) result);
                break;
            case 1:
                processTypeData((CampTypeBean) result);
                break;
        }
    }

    @OnClick({R2.id.tv_camp_type, R2.id.iv_camp_map,R2.id.v_shadow})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.tv_camp_type) {
            //类型
           if (isOpen){
               rvType.setVisibility(View.VISIBLE);
               vShadow.setVisibility(View.VISIBLE);
           }else {
               rvType.setVisibility(View.GONE);
               vShadow.setVisibility(View.GONE);
           }
            isOpen = !isOpen;
        } else if (id == R.id.iv_camp_map) {
           //地图
        }else if (id == R.id.v_shadow){
            rvType.setVisibility(View.GONE);
            vShadow.setVisibility(View.GONE);
            isOpen = true;
        }
    }

    @Override
    public void onLoadMoreRequested() {
        if (mPage >= countPage) {
            campAdapter.loadMoreEnd();
        } else {
            mPage++;
            getCampList(mPage);
        }
    }


    /**
     * 获取营地列表
     */
    private void getCampList(int page) {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("page", page);
        if (type !=null) {
            map.put("type", type);
        }
        mPresenter.getData(RvFrameConfig.VEHICLE_CAMPLIST, 0, CampApi.TRAVEL_CAMPSITESHOP, CampListBean.class, map, page == 1 ? true : false);
    }

    private void getCampTypeList(){
        mPresenter.getData(RvFrameConfig.VEHICLE_CAMPLIST,1,CampApi.TRAVEL_CAMPSITETAG, CampTypeBean.class,false);
    }


    private void processTypeData(CampTypeBean bean) {
        campTypeListAdapter.setNewData(bean.getData());
    }



    /**
     * 刷新数据
     */
    private void onRefresh() {
        mPage = 1;
        getCampList(mPage);
    }

    private void processData(CampListBean bean) {
        if (mPage == 1) {
            if (bean.getData().getTotalCount() == 0) {
                campAdapter.setEmptyView(getEmptyView(rvContent, -1, "还没有营地信息！"));
                return;
            }

            countPage = bean.getData().getTotalPage();
            campAdapter.setNewData(bean.getData().getData());
            campAdapter.loadMoreComplete();
        } else {
            campAdapter.addData(bean.getData().getData());
            campAdapter.loadMoreComplete();
        }
    }


    public class AbSpacesItemDecoration extends RecyclerView.ItemDecoration {

        private int space;

        public AbSpacesItemDecoration(int space) {
            this.space = space;
        }

        @Override
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            outRect.left = space;
            outRect.right = space;
            outRect.bottom = space;
            outRect.top = space;
        }
    }

}
