package com.ruiwenliu.wrapper.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * Created :Auser
 * Date: 2019/5/20.
 * Desc:时间管理工具类
 */

public class TimeManager {

    /**
     * 通过时间秒毫秒数判断两个时间的间隔
     * @param date1
     * @param date2
     * @return
     */
    public static   int differentDaysByMillisecond(Date date1,Date date2)
    {
        int days = (int) ((date2.getTime() - date1.getTime()) / (1000*3600*24));
        return days;
    }

    /**
     * 获取多少天后日期
     * @param day
     * @return
     */
    public static String  getAfterDay(int day){
        Date date=new Date();//取时间
        Calendar calOut =new GregorianCalendar();
        calOut.add(calOut.DATE,2);//把日期往后增加一天.整数往后推,负数往前移动
        date=calOut.getTime(); //这个时间就是日期往后推一天的结果
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
         String dateString = formatter.format(date);

         return dateString;
    }

    /**
     * 获取剩余多少天
     * @param dateStr1
     * @param dateStr2
     * @return
     */
    public static int getDays(String dateStr1,String dateStr2) {
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date1 = format1.parse(dateStr1);
            Date date2 = format2.parse(dateStr2);
          return   differentDaysByMillisecond( date1, date2);

        } catch (ParseException e) {
            e.printStackTrace();
        }
       return 0;
    }



    /*
     * 将时间转换为时间戳
     */
    public static   long dateToStamp(String s) throws ParseException{
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = simpleDateFormat.parse(s);
        return  date.getTime();
    }

    /*
     * 将时间戳转换为时间
     */
    public static String stampToDate(String s){
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        long lt = new Long(s);
        Date date = new Date(lt);
        return simpleDateFormat.format(date);
    }

    public static String stampToDate2(String s){
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
        long lt = new Long(s);
        Date date = new Date(lt);
        return simpleDateFormat.format(date);
    }
}
