package com.rv.travel.adapter;

import android.support.annotation.Nullable;
import android.support.v7.widget.CardView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.travel.R;
import com.rv.travel.bean.BeanHot;

import java.util.List;

public class AdapterHot extends BaseQuickAdapter<BeanHot, AdapterHot.AdapterViewHolder> {
    public interface OnItemRootClickListener {
        void onItemClick(BeanHot bean);
    }

    private OnItemRootClickListener itemClickListener;

    public void setOnItemRootClickListener(OnItemRootClickListener itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public AdapterHot(int layoutResId, @Nullable List<BeanHot> data) {
        super(layoutResId, data);
    }

    @Override
    protected void convert(AdapterViewHolder helper, final BeanHot item) {
        helper.itemRoot.setTag(item);

        helper.itemRoot.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (itemClickListener != null) {
                    BeanHot beanHot = (BeanHot) v.getTag();
                    itemClickListener.onItemClick(beanHot);
                }
            }
        });

        helper.itemText.setText(item.getName());
//        GlideManager.getInstance(helper.itemImage.getContext()).loadImage(item.getImg(),helper.itemImage);
    }

    public class AdapterViewHolder extends BaseViewHolder {

        CardView itemRoot;
        TextView itemText;
        ImageView itemImage;

        public AdapterViewHolder(View view) {
            super(view);
            itemRoot = view.findViewById(R.id.item_hot_card_view);
            itemImage = view.findViewById(R.id.item_hot_bg_img);
            itemText = view.findViewById(R.id.item_hot_text);
        }
    }
}
