package com.rv.share;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.support.v7.widget.CardView;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.base.utils.ui.image.round.RoundImageView;
import com.ruiwenliu.wrapper.SPConstance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.bean.UserInfoBean;
import com.ruiwenliu.wrapper.util.UtilsManager;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.DisplayUtil;
import com.rv.component.utils.RvCache;
import com.rv.component.utils.ZxingUtils;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.share.presenter.ReativeBillPresenter;
import com.yuyife.okgo.OkGoUtil;

import butterknife.BindView;
import butterknife.OnClick;

public class ReativeBillActivity extends BaseStatusActivity<ReativeBillPresenter> {

    private String url;
    @BindView(R2.id.ring_header)
    RoundImageView roundImageView;
    @BindView(R2.id.tv_phone)
    TextView tvPhone;
    @BindView(R2.id.img_qrcode)
    ImageView imgQrcode;
    @BindView(R2.id.btn_save_bill)
    Button btnSaveBill;
    @BindView(R2.id.btn_share)
    Button btnShare;
    @BindView(R2.id.ll_bill_content)
    CardView llBillContent;
    @BindView(R2.id.ll_content)
    LinearLayout llContent;

    public static Intent getIntent(Context context, String url) {
        Intent intent = new Intent(context, ReativeBillActivity.class);
        intent.putExtra("url", url);
        return intent;
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_reative_bill;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setVisibility(View.GONE);
        url = intent.getStringExtra("url");
        if (!TextUtils.isEmpty(url)) {
            Bitmap bitmap = ZxingUtils.createQRImage(url, DisplayUtil.dip2px(this, 150), DisplayUtil.dip2px(this, 150), BitmapFactory.decodeResource(getResources(), com.rv.home.R.mipmap.ic_launcher));

            imgQrcode.setImageBitmap(bitmap);
        }

        UserInfoBean userInfoBean = (UserInfoBean) RvCache.getInstance(getApplicationContext()).get(CacheEnum.USER);

        String name = userInfoBean.getData().getNickname();
        String url = userInfoBean.getData().getHeadimgurl();
        if (!TextUtils.isEmpty(url)) {
            GlideManager.getInstance(getApplicationContext()).loadImage3(url, roundImageView);
        }
        if (!TextUtils.isEmpty(name)) {
            tvPhone.setText(name);
        }
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @OnClick({R2.id.btn_save_bill, R2.id.btn_share})
    public void onViewClicked(View view) {
        int id = view.getId();

        if (id == R.id.btn_save_bill) {
            mPresenter.saveBill(llContent);
        } else if (id == R.id.btn_share) {
            mPresenter.saveShare(llContent);
        }
    }
}
