package com.xxrv.coupon;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.fastjson.JSON;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.xxrv.coupon.adapter.CarCouponAdapter;
import com.xxrv.coupon.bean.CouponBean;
import com.xxrv.coupon.presenter.CouponAllPresenter;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 租车优惠券
 */
@Route(path = Constance.ACTIVITY_URL_CARCOUPON)
public class CarCouponActivity extends BaseStatusActivity<CouponAllPresenter> {
    @BindView(R2.id.rv_content)
    RecyclerView rvContent;

    private CarCouponAdapter mAdapter;
    List<CouponBean.DataBean> couponBeans;

    @Autowired()
    String coupon;

    private List<CouponBean.DataBean> couponList;
    private boolean select;  //保留上一次选中的

    @Override
    protected int setLayout() {
        return R.layout.activity_car_coupon;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("优惠券");

        couponList = new ArrayList<>();

        mAdapter = new CarCouponAdapter();
        rvContent.setLayoutManager(new LinearLayoutManager(mActivity, LinearLayoutManager.VERTICAL, false));
        rvContent.setAdapter(mAdapter);

        if (coupon != null) {
            couponBeans = JSON.parseArray(coupon, CouponBean.DataBean.class);
            mAdapter.addData(couponBeans);
        }

        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                CouponBean.DataBean item = (CouponBean.DataBean) adapter.getItem(position);
                if ("1".equals(item.getStatus())) {
                    select = item.isCheck();
                    List<CouponBean.DataBean> data = mAdapter.getData();
                    if (data !=null && data.size() >0){
                        for (int i = 0; i < data.size(); i++) {
                            if (data.get(i).getType().equals(item.getType())){
                                data.get(i).setCheck(false);
                            }
                        }
                        if (select){
                            item.setCheck(false);
                        }else {
                            item.setCheck(true);
                        }
                    }
                    mAdapter.notifyDataSetChanged();
                }
            }
        });
    }


    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @OnClick(R2.id.btn_item_ok)
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.btn_item_ok) {
            couponList.clear();
            List<CouponBean.DataBean> data = mAdapter.getData();
            if (data !=null && data.size() >0){
                for (int i = 0; i < data.size(); i++) {
                    if (data.get(i).isCheck()){
                        couponList.add(data.get(i));
                    }
                }
            }
            getIntent().putExtra("resultCouponList",JSON.toJSONString(data));
            getIntent().putExtra("selectCoupon", JSON.toJSONString(couponList));
            setResult(RESULT_OK, getIntent());
            finish();
        }
    }
}
