package com.rv.home.rv.module.ui.main.home;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;

import com.frame.rv.config.RvFrameConfig;
import com.google.gson.annotations.SerializedName;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.tencent.mm.opensdk.modelpay.PayReq;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;

import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.OnClick;

public class PayForActivity extends BaseStatusActivity<CommonPresenter> {
    @BindView(R2.id.btn_weixin)
    Button btnWeixin;
    @BindView(R2.id.btn_ali)
    Button btnAli;
    private IWXAPI api;
//    @Override
//    protected void onCreate(Bundle savedInstanceState) {
//        super.onCreate(savedInstanceState);
//        setContentView(R.layout.activity_pay_for);
//    }
public static Intent getIntent(Context context) {
    return new Intent(context, PayForActivity.class);

}
    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }

    @Override
    protected int setLayout() {
        return R.layout.activity_pay_for;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("支付");
        api = WXAPIFactory.createWXAPI(this, RvFrameConfig.APP_ID);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        pay((PayToData) result);
    }


    @OnClick({R2.id.btn_weixin, R2.id.btn_ali})
    public void onViewClicked(View view) {
        int i = view.getId();
        if (i == R.id.btn_weixin) {
            requestPay();

        } else if (i == R.id.btn_ali) {
            pay(null);

        }
    }

    private void pay(PayToData data) {
        String url = "https://wxpay.wxutil.com/pub_v2/app/app_pay.php";
//        Button payBtn = (Button) findViewById(R.id.appay_btn);
//        payBtn.setEnabled(false);
//        Toast.makeText(PayActivity.this, "获取订单中...", Toast.LENGTH_SHORT).show();
        try{

                    PayReq req = new PayReq();
                    //req.appId = "wxf8b4f85f3a794e77";  // 测试用appId
                    req.appId			= "wx9c9d978e5698d00f";
                    req.partnerId		=  "1514583081";
                    req.prepayId		= "wx03100857518595b4daf63bfd1952595000";
                    req.nonceStr		=  "ebee6c24e331cd8834a051ff0cea3a7a";
                    req.timeStamp		="1559527678";
                    req.packageValue	= "Sign=WXPay";
                    req.sign			= "E43C7FA25B037B72B650A487998B2B47";
                    req.extData			= "app data"; // optional

                    api.sendReq(req);

        }catch(Exception e){
                       showToast("异常");
        }

    }

    public void requestPay(){
        Map<String,Object> map=new LinkedHashMap<>();
        map.put("Authorization","eyJhbGciOiJSUzI1NiJ9.eyJzdWIiOiIxMzYxMjY4ODUzOSIsInVzZXJJZCI6IjciLCJyZXF1ZXN0VHlwZSI6IkFQUCIsImV4cCI6MTU1OTU0MjAyOX0.s2_aejc9vFqRHC0fnVM_rDO-D0WXsE33bAYoJspRrvVhXLgfC-HblR3Nk5y5imql6nRGfhEpHd4kJT11cBDT3cSFpIOBomnUf9bMzcjLe4Dr8q61TkRq7khh2ftJP2bY_ylRbvcFU5okjlcojAnSFi3fa0s4wTdkLsGvmqf0pqM");
        mPresenter.postBodyData(RvFrameConfig.VEHICLE_UPLOAD,0, ApiConfig.HTTP_URL_WEIXIN_PAY, PayToData.class, new PayData("12586598","211",1,1,1,"10.1.37.192","商品1","支付","ssss",1),map,true);
    }

    public class PayData {
        public PayData(String orderNo, String userId, int payWay, int channel, int type, String buyerIp, String subject, String body, String notifyUrl, int amount) {
            this.orderNo = orderNo;
            this.userId = userId;
            this.payWay = payWay;
            this.channel = channel;
            this.type = type;
            this.buyerIp = buyerIp;
            this.subject = subject;
            this.body = body;
            this.notifyUrl = notifyUrl;
            this.amount = amount;
        }

        /**
         * orderNo : 12586598
         * userId : 211
         * payWay : 1
         * channel : 1
         * type : 1
         * buyerIp : 10.1.37.192
         * subject : 商品1
         * body : 支付
         * notifyUrl : ssss
         * amount : 1
         */

        private String orderNo;
        private String userId;
        private int payWay;
        private int channel;
        private int type;
        private String buyerIp;
        private String subject;
        private String body;
        private String notifyUrl;
        private int amount;

        public String getOrderNo() {
            return orderNo;
        }

        public void setOrderNo(String orderNo) {
            this.orderNo = orderNo;
        }

        public String getUserId() {
            return userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public int getPayWay() {
            return payWay;
        }

        public void setPayWay(int payWay) {
            this.payWay = payWay;
        }

        public int getChannel() {
            return channel;
        }

        public void setChannel(int channel) {
            this.channel = channel;
        }

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getBuyerIp() {
            return buyerIp;
        }

        public void setBuyerIp(String buyerIp) {
            this.buyerIp = buyerIp;
        }

        public String getSubject() {
            return subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getBody() {
            return body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public String getNotifyUrl() {
            return notifyUrl;
        }

        public void setNotifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
        }

        public int getAmount() {
            return amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }
    }


    public class  PayToData extends BaseBean{

        /**
         * data : {"package":"Sign=WXPay","appid":"wx9c9d978e5698d00f","sign":"180F1140BB832B9AFD2F3A004009C675","partnerid":"1514583081","prepayid":"wx291947357815824dbfc896009915601400","noncestr":"78bf2cc2743032339a08797b0776c78e","timestamp":"1559130404"}
         */

        private DataBean data;

        public DataBean getData() {
            return data;
        }

        public void setData(DataBean data) {
            this.data = data;
        }

        public class DataBean {
            /**
             * package : Sign=WXPay
             * appid : wx9c9d978e5698d00f
             * sign : 180F1140BB832B9AFD2F3A004009C675
             * partnerid : 1514583081
             * prepayid : wx291947357815824dbfc896009915601400
             * noncestr : 78bf2cc2743032339a08797b0776c78e
             * timestamp : 1559130404
             */

            @SerializedName("package")
            private String packageX;
            private String appid;
            private String sign;
            private String partnerid;
            private String prepayid;
            private String noncestr;
            private String timestamp;

            public String getPackageX() {
                return packageX;
            }

            public void setPackageX(String packageX) {
                this.packageX = packageX;
            }

            public String getAppid() {
                return appid;
            }

            public void setAppid(String appid) {
                this.appid = appid;
            }

            public String getSign() {
                return sign;
            }

            public void setSign(String sign) {
                this.sign = sign;
            }

            public String getPartnerid() {
                return partnerid;
            }

            public void setPartnerid(String partnerid) {
                this.partnerid = partnerid;
            }

            public String getPrepayid() {
                return prepayid;
            }

            public void setPrepayid(String prepayid) {
                this.prepayid = prepayid;
            }

            public String getNoncestr() {
                return noncestr;
            }

            public void setNoncestr(String noncestr) {
                this.noncestr = noncestr;
            }

            public String getTimestamp() {
                return timestamp;
            }

            public void setTimestamp(String timestamp) {
                this.timestamp = timestamp;
            }
        }
    }
}
