package com.xxfc.discovery.fragment;

import android.graphics.Rect;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.alibaba.android.arouter.launcher.ARouter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.url.Constance;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.xxfc.discovery.R;
import com.xxfc.discovery.R2;
import com.xxfc.discovery.adapter.DiscoveryRecommendAdapter;
import com.xxfc.discovery.api.DiscoveryApi;
import com.xxfc.discovery.bean.DiscoveryRecommendBean;
import com.xxfc.discovery.presenter.DiscoveryPresenter;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;

/**
 * 推荐
 */
public class RecommendFragment extends BaseFragment<DiscoveryPresenter> implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout mSimpleRefreshLayout;

    private DiscoveryRecommendAdapter mRecommendAdapter;
    private int countPage;
    private int mPage;

    public static RecommendFragment getInstance(int type) {
        Bundle bundl = new Bundle();
        bundl.putInt("type", type);
        RecommendFragment fragment = new RecommendFragment();
        fragment.setArguments(bundl);
        return fragment;
    }

    @Override
    public int getViewLayout() {
        return R.layout.fragment_recommend;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        mSimpleRefreshLayout.setHeaderView(new SimpleRefreshView(_mActivity));
        mSimpleRefreshLayout.setOnSimpleRefreshListener(this);
        mRecommendAdapter = new DiscoveryRecommendAdapter();
        rvContent.setLayoutManager(new GridLayoutManager(_mActivity, 2));
        rvContent.addItemDecoration(new AbSpacesItemDecoration(15));// 分割线。
        rvContent.setAdapter(mRecommendAdapter);
        mRecommendAdapter.bindToRecyclerView(rvContent);
        mRecommendAdapter.setEnableLoadMore(true);
        mRecommendAdapter.disableLoadMoreIfNotFullPage();

        mRecommendAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                DiscoveryRecommendBean.DataBeanX.DataBean item = (DiscoveryRecommendBean.DataBeanX.DataBean) adapter.getItem(position);
                if (item !=null){
                   if ("2".equals(item.getBody().getType())){
                       ARouter.getInstance()
                               .build(Constance.ACTIVITY_URL_DETAILPAT)
                               .withString("id", item.getMsgId())
                               .navigation();
                   }else if ("4".equals(item.getBody().getType())){
                       showToast("亲，该功能还在开发中。。。");
                   }
                }
            }
        });

        mRecommendAdapter.setOnItemChildClickListener(new BaseQuickAdapter.OnItemChildClickListener() {
            @Override
            public void onItemChildClick(BaseQuickAdapter adapter, View view, int position) {
                int id = view.getId();
                if (id == R.id.ll_item_islike){
                    showToast("222222");
                }
            }
        });

        mRecommendAdapter.setOnLoadMoreListener(new BaseQuickAdapter.RequestLoadMoreListener() {
            @Override public void onLoadMoreRequested() {
                if (rvContent != null) {
                    rvContent.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            if (mPage >= countPage) {
                                mRecommendAdapter.loadMoreEnd();
                            } else {
                                mPage++;
                                geDataList(mPage);
                            }
                        }
                    }, 200);
                }
            }
        }, rvContent);


    }


    @Override
    protected void loadData(Bundle savedInstanceState) {
        onFresh();
    }

    /**
     * 刷新
     */
    private void onFresh() {
        mPage = 1;
        geDataList(mPage);
    }

    /**
     * 请求数据
     *
     * @param page
     */
    private void geDataList(int page) {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("page", page);
        mPresenter.postData( 0, DiscoveryApi.DISCOVERY_HOTMSG_LIST, DiscoveryRecommendBean.class, map, page == 1 ? false : false);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        mSimpleRefreshLayout.onRefreshComplete();
        processData((DiscoveryRecommendBean) result);
    }

    private void processData(DiscoveryRecommendBean bean) {
        if (mPage == 1) {
            countPage = bean.getData().getTotalPage();
            mRecommendAdapter.setNewData(bean.getData().getList());
            if (bean.getData().getTotalCount() == 0) {
                mRecommendAdapter.setEmptyView(getEmptyView(rvContent, -1, "暂无推荐数据"));
                mRecommendAdapter.notifyDataSetChanged();
            }
        } else {
            mRecommendAdapter.addData(bean.getData().getList());
            mRecommendAdapter.loadMoreComplete();
        }
    }

    @Override
    public void onLoadMoreRequested() {
        if (mPage >= countPage) {
            mRecommendAdapter.loadMoreEnd();
        } else {
            mPage++;
            geDataList(mPage);
        }
    }

    @Override
    public void onRefresh() {
        onFresh();
    }


    public class AbSpacesItemDecoration extends RecyclerView.ItemDecoration {

        private int space;

        public AbSpacesItemDecoration(int space) {
            this.space = space;
        }

        @Override
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            int childCount = parent.getChildCount();
            outRect.left = space;
            outRect.right = space;
            outRect.bottom = space;
            outRect.top = space;
        }
    }

}
