package com.rv.component.dialog.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.component.dialog.R;
import com.rv.component.dialog.bean.OrderPriceDetailBean;

/**
 * Created :Auser
 * Date: 2019/5/31.
 * Desc:订单价格明细
 */

public class OrderPriceDetailAdapter extends BaseQuickAdapter<OrderPriceDetailBean.ChildrenBean,BaseViewHolder> {
    public OrderPriceDetailAdapter() {
        super(R.layout.rv_item_order_price_detail);
    }

    @Override
    protected void convert(BaseViewHolder helper, OrderPriceDetailBean.ChildrenBean item) {

        helper.setText(R.id.tv_name,item.getKey());
        helper.setText(R.id.tv_attr,item.getDetail());
        helper.setText(R.id.tv_price,item.getVal());
        if ("优惠券".equals(item.getKey())){
           helper.setTextColor(R.id.tv_name, helper.itemView.getContext().getResources().getColor(R.color.colorAuxiliaryRed));
            helper.setTextColor(R.id.tv_price, helper.itemView.getContext().getResources().getColor(R.color.colorAuxiliaryRed));
        }else {
            helper.setTextColor(R.id.tv_name, helper.itemView.getContext().getResources().getColor(R.color.textMain));
            helper.setTextColor(R.id.tv_price, helper.itemView.getContext().getResources().getColor(R.color.textMain));
        }

    }
}
