package com.rv.travel.fragment;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;

import com.base.utils.base.BaseFragment;
import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.frame.base.FrameApp;
import com.frame.rv.OnModuleEventListener;
import com.just.agentweb.AgentWeb;
import com.rv.travel.R;
import com.rv.travel.R2;
import com.rv.travel.TravelActivity;
import com.yuyife.okgo.OkGoUtil;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.Unbinder;

//旅游详情
public class TravelWebFragment extends BaseFragment {

    public static TravelWebFragment getInstance(String url) {
        TravelWebFragment instance = new TravelWebFragment();
        instance.URL_ADDRESS = url;
        return instance;
    }

    private String URL_ADDRESS = "";
    @BindView(R2.id.travel_web_fragment_root)
    FrameLayout rootLayout;

    LinearLayout buttonLayout;
    public void showButtonLayout() {
        FrameApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                buttonLayout.setVisibility(View.VISIBLE);
            }
        });
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_web, container, false);
        buttonLayout = view.findViewById(R.id.travel_web_button_layout);

        unbinder = ButterKnife.bind(this, view);
        view.findViewById(R.id.travel_web_service_button).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //showToastShort("联系客服");
            }
        });
        view.findViewById(R.id.travel_web_subscribe_button).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (TextUtil.isEmpty(OkGoUtil.getToken())) {
                    showToastShort("请先登录");
                    TravelActivity.isNeedLogin = true;
//                    if (ModuleEventUtil.getOnModuleEventListener() != null) {
//                        ModuleEventUtil.getOnModuleEventListener().onLogin(OnModuleEventListener.MODULE_LOGIN_START);
//                    }
                    return;
                }
                buttonLayout.setVisibility(View.GONE);
                mAgentWeb.getJsAccessEntrace().quickCallJs("openModal");
            }
        });
        return view;
    }

    Unbinder unbinder;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        onData();
        onView();
    }


    @Override
    public void onData() {


    }

    @Override
    public void onView() {
        goWeb();

    }


    @Override
    public void onDestroyView() {
        super.onDestroyView();

    }

    AgentWeb mAgentWeb;

    private void goWeb() {
        mAgentWeb = AgentWeb.with(this)
                .setAgentWebParent(rootLayout, new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT))
                .useDefaultIndicator()
                .createAgentWeb()
                .ready()
                .go(URL_ADDRESS);

        mAgentWeb.getJsInterfaceHolder().addJavaObject("android", new AndroidInterface(this));

    }
}
