package com.frame.base.dialog;

import android.app.Activity;
import android.content.DialogInterface;
import android.widget.TextView;

import com.base.utils.base.BaseActivity;
import com.base.utils.tools.android.IntentUtil;
import com.base.utils.tools.android.LanguageUtil;
import com.base.utils.tools.android.SPUtil;
import com.base.utils.tools.android.ActivityUtil;
import com.base.utils.ui.dialog.DialogUtil;
import com.yuyife.framebase.R;

import java.util.ArrayList;
import java.util.List;

/**
 * 切换语言
 */

public class DialogLanguage {
    public static void switchLanguageV7(final BaseActivity context, final Class<? extends Activity> clazz, final TextView textView) {
        DialogUtil.getItemDialog(context,
                new String[]{context.getString(R.string.resource_label_language_zh),
                        context.getString(R.string.resource_label_language_en)},
                new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {
                        switch (i) {
                            case 0:
                                //中文
                                LanguageUtil.switchAppLanguage(context, SPUtil.APP_LANGUAGE_ZH);
                                if (textView != null) {
                                    textView.setText(context.getString(R.string.resource_label_language_zh));
                                }

                                break;
                            case 1:
                                //英文
                                LanguageUtil.switchAppLanguage(context, SPUtil.APP_LANGUAGE_EN);
                                if (textView != null) {
                                    textView.setText(context.getString(R.string.resource_label_language_en));
                                }

                                break;
                        }
                        dialogInterface.dismiss();
                        context.finish();
                        IntentUtil.startActivity(context, clazz);
                    }
                }
        ).setTitle(context.getString(R.string.resource_label_language)).create().show();
    }

    public static void switchLanguage(final BaseActivity context, final Class<? extends Activity> clazz, final TextView textView) {
        List<String> values = new ArrayList<>();
        values.add(context.getString(R.string.resource_label_language_zh));
        values.add(context.getString(R.string.resource_label_language_en));
        DialogUtil.showRecyclerDialog(context, context.getString(R.string.resource_label_language), values, new DialogUtil.AdapterDialogRecycler.OnClickListener() {
            @Override
            public void onItemClick(String value) {
                if (value.equals(context.getString(R.string.resource_label_language_zh))) {
                    //中文
                    LanguageUtil.switchAppLanguage(context, SPUtil.APP_LANGUAGE_ZH);
                    if (textView != null) {
                        textView.setText(context.getString(R.string.resource_label_language_zh));
                    }
                } else if (value.equals(context.getString(R.string.resource_label_language_en))) {
                    //英文
                    LanguageUtil.switchAppLanguage(context, SPUtil.APP_LANGUAGE_EN);
                    if (textView != null) {
                        textView.setText(context.getString(R.string.resource_label_language_en));
                    }
                }
                context.finish();
                ActivityUtil.finishAllActivity();
                IntentUtil.startActivity(context, clazz);
            }
        });


    }
}
