package com.base.animset;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

import com.base.animset.util.DialogEffects;
import com.base.animset.wedgit.NiftyDialogBuilder;


public class DialogSimple extends Activity {

    private DialogEffects effect;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(com.base.animset.R.layout.anim_sample_dialog);

    }

    public void dialogShow(View v) {
        NiftyDialogBuilder dialogBuilder = NiftyDialogBuilder.getInstance(this);

        int i = v.getId();
        if (i == com.base.animset.R.id.fadein) {
            effect = DialogEffects.Fadein;

        } else if (i == com.base.animset.R.id.slideright) {
            effect = DialogEffects.Slideright;

        } else if (i == com.base.animset.R.id.slideleft) {
            effect = DialogEffects.Slideleft;

        } else if (i == com.base.animset.R.id.slidetop) {
            effect = DialogEffects.Slidetop;

        } else if (i == com.base.animset.R.id.slideBottom) {
            effect = DialogEffects.SlideBottom;

        } else if (i == com.base.animset.R.id.newspager) {
            effect = DialogEffects.Newspager;

        } else if (i == com.base.animset.R.id.fall) {
            effect = DialogEffects.Fall;

        } else if (i == com.base.animset.R.id.sidefall) {
            effect = DialogEffects.Sidefill;

        } else if (i == com.base.animset.R.id.fliph) {
            effect = DialogEffects.Fliph;

        } else if (i == com.base.animset.R.id.flipv) {
            effect = DialogEffects.Flipv;

        } else if (i == com.base.animset.R.id.rotatebottom) {
            effect = DialogEffects.RotateBottom;

        } else if (i == com.base.animset.R.id.rotateleft) {
            effect = DialogEffects.RotateLeft;

        } else if (i == com.base.animset.R.id.slit) {
            effect = DialogEffects.Slit;

        } else if (i == com.base.animset.R.id.shake) {
            effect = DialogEffects.Shake;

        }

        dialogBuilder
                .withTitle("Modal Dialog")                                  //.withTitle(null)  no title
                .withTitleColor("#FFFFFF")                                  //def
                .withDividerColor("#11000000")                              //def
                .withMessage("This is a modal Dialog.")                     //.withMessage(null)  no Msg
                .withMessageColor("#FFFFFFFF")                              //def  | withMessageColor(int resid)
                .withDialogColor("#FFE74C3C")                               //def  | withDialogColor(int resid)                               //def
                .withIcon(getResources().getDrawable(com.base.animset.R.drawable.icon_lion))
                .isCancelableOnTouchOutside(true)                           //def    | isCancelable(true)
                .withDuration(700)                                          //def
                .withEffect(effect)                                         //def BaseDialogEffects.Slidetop
                .withButton1Text("OK")                                      //def gone
                .withButton2Text("Cancel")                                  //def gone
                .setCustomView(com.base.animset.R.layout.anim_sample_dialog_custom_view, v.getContext())         //.setCustomView(View or ResId,context)
                .setButton1Click(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        Toast.makeText(v.getContext(), "i'm btn1", Toast.LENGTH_SHORT).show();
                    }
                })
                .setButton2Click(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        Toast.makeText(v.getContext(), "i'm btn2", Toast.LENGTH_SHORT).show();
                    }
                })
                .show();

    }


}
