package com.xxrv.wallet.adapter;

import android.support.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.component.utils.DateUtils;
import com.xxrv.wallet.R;
import com.xxrv.wallet.bean.ConsumeListBean;

import java.util.List;

public class ConsumeListAdapter extends BaseQuickAdapter<ConsumeListBean.ConsumeItem, BaseViewHolder> {
    public ConsumeListAdapter(@Nullable List<ConsumeListBean.ConsumeItem> data) {
        super(R.layout.item_consume, data);
    }


    @Override
    protected void convert(BaseViewHolder helper, ConsumeListBean.ConsumeItem item) {
     /*   switch (item.getSource()) {
            case 0:
                helper.setText(R.id.tv_consume_name, "活动奖励金");
                break;
            case 1:
                helper.setText(R.id.tv_consume_name, "佣金");
                break;
            case 2:
                helper.setText(R.id.tv_consume_name, "会员充值");
                break;
            case 10:
                helper.setText(R.id.tv_consume_name, "提现");
                break;
            case 11:
                helper.setText(R.id.tv_consume_name, "转账");
                break;
            case 12:
                helper.setText(R.id.tv_consume_name, "购买");
                break;
            case 13:
                helper.setText(R.id.tv_consume_name, "手续费");
                break;
            default:
                break;
        }*/

        helper.setText(R.id.tv_consume_name, item.getDesc());

        helper.setText(R.id.tv_income_time, DateUtils.timestampToString1(item.getCrtTime()));
        StringBuilder builder = new StringBuilder();
        if (item.getItype() == 0) {
            builder.append("+");
        } else {
            builder.append("-");
        }
        builder.append("¥").append(item.getAmount());
        helper.setText(R.id.tv_amount, builder.toString());

    }
}
