package com.rv.version;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.TextView;

import com.ruiwenliu.wrapper.dialog.BaseDialog;

/**********
 * 强制升级界面
 */
public class UpdateForceDialog extends BaseDialog implements DownListenerManager.DownListener {


    private TextView tvDownloadInfo;

    public UpdateForceDialog(Context context, int themeResId) {
        super(context, themeResId);
        DownListenerManager.getInstance().addDownListener(this);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
        setCancelable(false);

        tvDownloadInfo = findViewById(R.id.tv_download_info);
    }

    public UpdateForceDialog(@NonNull Context context) {
        this(context, 0);
    }

    @Override
    public int getViewLayout() {
        return R.layout.dialog_update_force_view;
    }


    @Override
    public void pending() {
        tvDownloadInfo.setText("下载准备中...");
    }

    @Override
    public void paused() {
        tvDownloadInfo.setText("下载暂停中...");
    }

    @Override
    public void progress(int progress) {
        tvDownloadInfo.setText("下载中..." + progress + "%");
    }

    @Override
    public void completed() {
        tvDownloadInfo.setText("下载完成");
        dismiss();
    }

    @Override
    public void error() {
        tvDownloadInfo.setText("下载失败");
        setCancelable(true);
    }

    @Override
    public void dismiss() {
        super.dismiss();
        DownListenerManager.getInstance().removeDownListener(this);
    }
}
