package com.rv.member.view;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.rv.member.R;
import com.rv.member.bean.MemberListBean;

import java.math.BigDecimal;

public class MemberRightItem extends LinearLayout {

    private TextView tvMemberLevel;
    private TextView tvMemberDiscount;
    private TextView tvMemberFreeDay;

    public MemberRightItem(Context context) {
        super(context);
        initView();
    }

    private void initView() {
        View view = LayoutInflater.from(getContext()).inflate(R.layout.view_member_right_item, null);
        tvMemberLevel = view.findViewById(R.id.tv_member_level);
        tvMemberDiscount = view.findViewById(R.id.tv_member_discount);
        tvMemberFreeDay = view.findViewById(R.id.tv_member_free_day);
        addView(view, LinearLayout.LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
    }

    public void setData(MemberListBean.MemberCard memberCard, int position) {
        if (memberCard != null) {
            this.tvMemberLevel.setText(TextUtils.isEmpty(memberCard.getName()) ? " " : memberCard.getName());
            this.tvMemberDiscount.setText("永久" + (memberCard.getDiscount() / 10) + "折");

            StringBuilder builder = new StringBuilder(memberCard.getNumber() + "天");
            if (memberCard.getDaysPrice() != null) {
                builder.append("\n 价值 ¥" + dealPrice(memberCard.getDaysPrice()));
            }
            SpannableStringBuilder rentBuilder = new SpannableStringBuilder(builder.toString());
            String rentText = rentBuilder.toString();
            rentBuilder.setSpan(new ForegroundColorSpan(Color.parseColor("#FF5050")), rentText.indexOf("¥"), rentBuilder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            this.tvMemberFreeDay.setText(rentBuilder);
        }

        if (position % 2 != 0) {
            setBackgroundColor(Color.parseColor("#fff6e2"));
        }
    }

    private String dealPrice(BigDecimal value) {
        if (value == null) return "";
        BigDecimal noZeros = value.stripTrailingZeros();
        return noZeros.toPlainString();
    }
}
