package com.rv.im.util;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.NotificationCompat;

import com.rv.im.ConversationListActivity;
import com.rv.im.CustomerListActivity;
import com.rv.im.R;

public class NotificationMananger {

    private NotificationMananger() {
    }


    public static void showNewsNotification(Context context, String fromId) {
        NotificationManager manager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
        NotificationCompat.Builder builder;
        //判断是否是8.0Android.O
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            NotificationChannel chan1 = new NotificationChannel("1", "newChannel", NotificationManager.IMPORTANCE_HIGH);
            manager.createNotificationChannel(chan1);
            builder = new NotificationCompat.Builder(context, "1");
        } else {
            builder = new NotificationCompat.Builder(context);
        }
//
//        Intent intent = new Intent();
//        intent.setComponent(new ComponentName(context, "com.xxfc.rv."));
//        intent.putExtra("to","chat") ;
//        intent.putExtra("fromId",fromId) ;
//
        Intent intent = new Intent(context, CustomerListActivity.class);
        PendingIntent pendingIntent = PendingIntent.getActivity(context, 0, intent, 0);
        Notification notification = builder.setTicker("您有新的消息")
                .setSmallIcon(R.mipmap.logo)
                .setWhen(System.currentTimeMillis())
                .setContentIntent(pendingIntent)
                .setContentTitle("滴房车")
                .setContentText("您有新的消息")
                .setAutoCancel(true)
                .setPriority(Notification.PRIORITY_DEFAULT)
                .build();

        manager.notify(0, notification);

    }


    public static void showNewsFriendNotification(Context context, String fromId) {
        NotificationManager manager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
        NotificationCompat.Builder builder;
        //判断是否是8.0Android.O
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            NotificationChannel chan1 = new NotificationChannel("1", "newChannel", NotificationManager.IMPORTANCE_HIGH);
            manager.createNotificationChannel(chan1);
            builder = new NotificationCompat.Builder(context, "1");
        } else {
            builder = new NotificationCompat.Builder(context);
        }
//
//        Intent intent = new Intent();
//        intent.setComponent(new ComponentName(context, "com.xxfc.rv."));
//        intent.putExtra("to","chat") ;
//        intent.putExtra("fromId",fromId) ;
//
        Intent intent = new Intent(context, ConversationListActivity.class);
        PendingIntent pendingIntent = PendingIntent.getActivity(context, 0, intent, 0);
        Notification notification = builder.setTicker("您有新的消息")
                .setSmallIcon(R.mipmap.logo)
                .setWhen(System.currentTimeMillis())
                .setContentIntent(pendingIntent)
                .setContentTitle("滴房车")
                .setContentText("好友添加请求")
                .setAutoCancel(true)
                .setPriority(Notification.PRIORITY_DEFAULT)
                .build();

        manager.notify(0, notification);

    }
}
