package com.rv.im.util;//package com.xxfc.rv.util;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.RvCache;
import com.rv.im.AppConfig;
import com.rv.im.R;

import java.util.ArrayList;
import java.util.List;


/**
 * 用户头像的上传和获取
 */
public class AvatarHelper {


    public static final String ID_SYSTEM_MESSAGE = "10000";// 系统消息ID
    public static final String ID_NEW_FRIEND_MESSAGE = "10001";// 新朋友消息 ID
    public static final String ID_SK_PAY = "1100";// 支付公众号，
    public static final String ID_BLOG_MESSAGE = "10002";// 商务圈消息ID
    public static final String ID_INTERVIEW_MESSAGE = "10004";// 面试中心ID（用于职位、初试、面试的推送）
    public static final String ID_SYSTEM_NOTIFICATION = "10005";// 系统号，用于各种控制消息通知，

    private static final String TAG = "AvatarHelper";

    public static String getAvatarUrl(String userId, boolean isThumb) {
        if (TextUtils.isEmpty(userId) || userId.length() > 8) {
            return null;
        }
        int userIdInt = -1;
        try {
            userIdInt = Integer.parseInt(userId);
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (userIdInt == -1 || userIdInt == 0) {
            return null;
        }

        int dirName = userIdInt % 10000;
        String url = null;
        AppConfig appConfig = (AppConfig) RvCache.getInstance().get(CacheEnum.IM_CONFIG);
        if (appConfig == null) return "";
        if (isThumb) {
            url = appConfig.AVATAR_THUMB_PREFIX + "/" + dirName + "/" + userId + ".jpg";
        } else {
            url = appConfig.AVATAR_ORIGINAL_PREFIX + "/" + dirName + "/" + userId + ".jpg";
        }
        return url;
    }

//    public void displayRoundAvatar(String nickName, String userId, final ImageView imageView, final boolean isThumb) {
//        if (handlerSpecialAvatar(userId, imageView)) {
//            return;
//        }
//
//        String url = getAvatarUrl(userId, isThumb);
//        if (TextUtils.isEmpty(url)) {
//            return;
//        }
//        String time = UserAvatarDao.getInstance().getUpdateTime(userId);
//
//        Glide.with(MyApplication.getContext())
//                .load(url)
//                .placeholder(R.drawable.avatar_normal)
//                .signature(new StringSignature(time))
//                .dontAnimate()
//                .into(new SimpleTarget<GlideDrawable>() {
//                    @Override
//                    public void onResourceReady(GlideDrawable resource, GlideAnimation<? super GlideDrawable> glideAnimation) {
//                        imageView.setImageDrawable(resource);
//                    }
//
//                    @Override
//                    public void onLoadFailed(Exception e, Drawable errorDrawable) {
//                        super.onLoadFailed(e, errorDrawable);
//                        List<Object> bitmapList = new ArrayList();
//                        bitmapList.add(nickName);
//                        Bitmap avatar = AvatarUtil.getBuilder(mContext)
//                                .setShape(AvatarUtil.Shape.ROUND)
//                                .setList(bitmapList)
//                                .setTextSize(DisplayUtil.dip2px(mContext, 40))
//                                .setTextColor(R.color.white)
//                                .setTextBgColor(SkinUtils.getSkin(mContext).getAccentColor())
//                                .setBitmapSize(DisplayUtil.dip2px(mContext, 240), DisplayUtil.dip2px(mContext, 240))
//                                .create();
//                        BitmapDrawable bitmapDrawable = new BitmapDrawable(avatar);
//                        bitmapDrawable.setAntiAlias(true);
//                        imageView.setImageDrawable(bitmapDrawable);
//
//                    }
//                });
//    }

    private boolean handlerSpecialAvatar(String userId, ImageView iv) {
        if (userId.equals(ID_SYSTEM_MESSAGE)) {
            iv.setImageResource(R.drawable.im_notice);
            return true;
        } else if (userId.equals(ID_NEW_FRIEND_MESSAGE)) {
            iv.setImageResource(R.drawable.im_new_friends);
            return true;
        }
        return false;
    }

}
