package com.rv.im.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

public class RemoteReceiver extends BroadcastReceiver {

    private RemoteListener listener;

    public RemoteReceiver(RemoteListener listener) {
        this.listener = listener;
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        if (this.listener != null) {
            this.listener.remote();
        }
    }

    public interface RemoteListener {
        void remote();
    }
}
