package com.rv.im.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.rv.im.Constants;
import com.rv.im.listener.SendMessageListener;

/*****
 * 消息接收器
 */
public class MessageReceiver extends BroadcastReceiver {

    private SendMessageListener messageListener;

    public MessageReceiver(SendMessageListener listener) {
        this.messageListener = listener;
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (messageListener == null) return;
        if (Constants.ACTIONS.ACTION_SEND_RECEIVER.equals(action)) {
            messageListener.send(intent.getStringExtra(Constants.KEYS.KEY_MESSAGE_TARGET), intent.getStringExtra(Constants.KEYS.KEY_MESSAGE_CONTENT));
        }
//        else if (Constants.ACTIONS.ACTION_SEND_MSG_SUCCESS.equals(action)) {
//            messageListener.sendMsgSuccess(intent.getStringExtra(Constants.KEYS.KEY_USER_RECEIPTID));
//        }
//
//        else if (Constants.ACTIONS.ACTION_RECEIVE_NEW_MESSAGE.equals(action)) {
//            messageListener.receiverMsg(intent.getStringExtra(Constants.KEYS.KEY_NEW_MESSAGE));
//        }

//        else if (Constants.ACTIONS.ACTION_SEND_MSG_FAILURE.equals(action)) {
//            messageListener.sendMsgFailure(intent.getStringExtra(Constants.KEYS.KEY_USER_RECEIPTID));
//        }
    }
}
