package com.rv.im.presenter;

import android.content.Intent;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.callback.AbsCallback;
import com.lzy.okgo.model.Response;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.RvCache;
import com.rv.im.AppConfig;
import com.rv.im.Constants;
import com.rv.im.ImSetting;
import com.rv.im.bean.ImBaseBean;
import com.rv.im.db.service.ChatMessageServiceImp;
import com.rv.im.db.service.FriendServiceImp;
import com.rv.im.db.table.ChatMessage;
import com.rv.im.db.table.Friend;
import com.rv.im.enums.MessageTypeEnum;

import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;

import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;

public class NewFriendPresenter extends CommonPresenter {


    // 同意添加好友的请求
    public ChatMessage doAgree(String toUserName, String toUserId) {

        ChatMessage message = new ChatMessage();
        message.setMessageType(MessageTypeEnum.PASS);
        message.setToUserName(toUserName);
        message.setToUserId(toUserId);
        message.setContent("同意");
        return sendMessage(message);
    }

    private ChatMessage sendMessage(ChatMessage message) {

        message.setFromUserId(ImSetting.getUserId());
        message.setFromUserName(ImSetting.getUserName());
        message.setRead(true);
        message.setFromId("android");
        message.setPackId(UUID.randomUUID().toString().replaceAll("-", ""));
        message.setTimeSend(System.currentTimeMillis());
        sendMsgBroad(message);
        return message;
    }

    public void sendMsgBroad(ChatMessage message) {
        Intent intent = new Intent();
        intent.setAction(Constants.ACTIONS.ACTION_SEND_RECEIVER);
        intent.setPackage(getPresenterContext().getPackageName());
        intent.putExtra(Constants.KEYS.KEY_MESSAGE_TARGET, message.getToUserId());
        intent.putExtra(Constants.KEYS.KEY_MESSAGE_CONTENT, message.toJsonString());
        getPresenterContext().sendBroadcast(intent);
    }

    /**
     * 同意别人的加好友
     */
    public void doAgreeOrAttention(final Friend item, AttentionListener listener) {
        AppConfig appConfig = (AppConfig) RvCache.getInstance().get(CacheEnum.IM_CONFIG);
        if (appConfig == null) return;
        StringBuffer buffer = new StringBuffer();
        buffer.append(appConfig.Add_friends).append("?").append("access_token=").append(ImSetting.getImToken()).append("&toUserId=").append(item.getUserId());
        OkGo.<String>get(buffer.toString())
                .execute(new AbsCallback<String>() {
                    @Override
                    public void onSuccess(Response<String> response) {
                        okhttp3.Response rawResponse = response.getRawResponse();
                        ResponseBody responseBody = rawResponse.body();
                        String data = null;
                        try {
                            data = responseBody.string();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (!TextUtils.isEmpty(data)) {
                            ImBaseBean bean = new Gson().fromJson(data, ImBaseBean.class);
                            if (bean != null && bean.resultCode == 1) {
                                ((BaseStatusActivity) getPresenterContext()).showToast("已同意");
                                ChatMessage chatMessage = doAgree(item.getUserName(), item.getUserId());
                                ChatMessageServiceImp.getInstance(ImSetting.getContext()).addMessage(chatMessage);
                                item.setStatus(Friend.STATUS_12);
                                FriendServiceImp.getInstance(getPresenterContext()).addMessage(item);
                                listener.success();
                            } else if (bean != null) {
                                ((BaseStatusActivity) getPresenterContext()).showToast(bean.resultMsg);
                                if (bean.resultCode == 100512) {
                                    item.setStatus(2);
                                    FriendServiceImp.getInstance(getPresenterContext()).addMessage(item);
                                }
                                listener.failed();
                            }
                        }
                    }

                    @Override
                    public String convertResponse(okhttp3.Response response) {
                        return null;
                    }
                });
    }

    public interface AttentionListener {

        void success();

        void failed();
    }
}
