package com.rv.im.presenter;

import android.text.TextUtils;

import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.RvCache;
import com.rv.im.AppConfig;
import com.rv.im.ImSetting;
import com.rv.im.R;
import com.rv.im.bean.ContactsBean;
import com.rv.im.util.sortlist.PingYinUtil;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddressPresenter extends CommonPresenter {

    /******
     *
     * 初始化好友列表
     * @param lists
     */
    public void initAddress(List<ContactsBean.ContactItemBean> lists) {
        boolean isShowLoading = lists == null || lists.size() == 0;
        ContactsBean bean = (ContactsBean) RvCache.getInstance().get(CacheEnum.CONTACTS);
        if (bean != null && bean.getData() != null && bean.getData().size() > 0) {
            lists.addAll(bean.getData());
        }
        Collections.sort(lists, (o1, o2) -> {
            if(TextUtils.isEmpty(o1.getToNickname())){
                return 1;
            }
            if(TextUtils.isEmpty(o2.getToNickname())){
                return -1;
            }
            String pingyin = PingYinUtil.getPingYin(o2.getToNickname());
            String pingy = PingYinUtil.getPingYin(o1.getToNickname());
            if (!TextUtils.isEmpty(pingy) && !TextUtils.isEmpty(pingyin)) {
                return pingy.compareTo(pingyin);
            }
            return 0;
        });
        addTopDatas(lists);
        pullFriends(isShowLoading);
    }

    public void addTopDatas(List<ContactsBean.ContactItemBean> lists) {
        addCustomerItem(lists);
        addGroupItem(lists);
        addNewFriendItem(lists);
    }

    private void addNewFriendItem(List<ContactsBean.ContactItemBean> lists) {
        ContactsBean.ContactItemBean bean = new ContactsBean.ContactItemBean();
        bean.setType(0);
        bean.setToNickname(getPresenterContext().getString(R.string.text_new_friend));
        bean.setLocalHead(R.drawable.icon_lion);
        lists.add(2, bean);
    }

    private void addGroupItem(List<ContactsBean.ContactItemBean> lists) {
        ContactsBean.ContactItemBean bean = new ContactsBean.ContactItemBean();
        bean.setType(0);
        bean.setToNickname(getPresenterContext().getString(R.string.text_group));
        bean.setLocalHead(R.drawable.icon_lion);
        lists.add(1, bean);
    }

    private void addCustomerItem(List<ContactsBean.ContactItemBean> lists) {
        ContactsBean.ContactItemBean bean = new ContactsBean.ContactItemBean();
        bean.setType(0);
        bean.setToNickname(getPresenterContext().getString(R.string.text_customer_list));
        bean.setLocalHead(R.drawable.icon_lion);
        lists.add(0, bean);
    }


    /**
     * 从服务端获取好友列表，更新数据库
     */
    private void pullFriends(boolean isShowLoading) {
        AppConfig appConfig = (AppConfig) RvCache.getInstance().get(CacheEnum.IM_CONFIG);
        if (appConfig == null) return;
        Map<String, String> params = new HashMap<>();
        params.put("access_token", ImSetting.getImToken());
        getData(0, appConfig.FRIENDS_ATTENTION_LIST, ContactsBean.class, params, isShowLoading);
    }

}
