package com.rv.im.presenter;

import android.content.Intent;
import android.text.TextUtils;
import android.widget.Toast;

import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.RvCache;
import com.rv.im.AppConfig;
import com.rv.im.Constants;
import com.rv.im.ImSetting;
import com.rv.im.bean.AddResultBean;
import com.rv.im.bean.FriendSearchBean;
import com.rv.im.db.table.ChatMessage;
import com.rv.im.db.table.Friend;
import com.rv.im.enums.MessageTypeEnum;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;


public class AddFriendPresenter extends CommonPresenter {

    public void search(String mKeyWord) {
        if (TextUtils.isEmpty(mKeyWord)) {
            return;
        }

        AppConfig appConfig = (AppConfig) RvCache.getInstance().get(CacheEnum.IM_CONFIG);
        if (appConfig == null) return;

        HashMap<String, String> params = new HashMap<>();
        params.put("access_token", ImSetting.getImToken());
        params.put("pageIndex", String.valueOf(0));
        // params.put("pageSize", String.valueOf(AppConfig.PAGE_SIZE));
        params.put("pageSize", "20");
        params.put("nickname", mKeyWord);
        params.put("maxAge", String.valueOf(200));
        params.put("active", String.valueOf(0));

        getData(0, appConfig.USER_NEAR, FriendSearchBean.class, params, true);
    }

    public void addFriend(String userId, int fromAddType) {

        if (TextUtils.isEmpty(userId)) return;
        AppConfig appConfig = (AppConfig) RvCache.getInstance().get(CacheEnum.IM_CONFIG);
        if (appConfig == null) return;

        Map<String, String> params = new HashMap<>();
        params.put("access_token", ImSetting.getImToken());
        params.put("toUserId", userId);
        params.put("fromAddType", String.valueOf(fromAddType));

        getData(0,appConfig.FRIENDS_ATTENTION_ADD,AddResultBean.class,params,true);
    }

        // 打招呼
    public ChatMessage doSayHello(String text,String toUserName,String toUserId ) {
        if (TextUtils.isEmpty(text)) {
            text = "HEY-HELLO";
        }
        ChatMessage message = new ChatMessage();
        message.setMessageType(MessageTypeEnum.HELLO);
        message.setToUserName(toUserName);
        message.setToUserId(toUserId);
        message.setContent(text);
        return sendMessage(message);

    }

    public ChatMessage doSayAddFriend(String toUserName,String toUserId ){
        ChatMessage message = new ChatMessage();
        message.setMessageType(MessageTypeEnum.BE_FRIEND);
        message.setToUserName(toUserName);
        message.setToUserId(toUserId);
        message.setContent("be friend");
        return sendMessage(message);
    }


    private ChatMessage sendMessage(ChatMessage message) {

        message.setFromUserId(ImSetting.getUserId());
        message.setFromUserName(ImSetting.getUserName());
        message.setRead(true);
        message.setFromId("android");
        message.setPackId(UUID.randomUUID().toString().replaceAll("-", ""));
        message.setTimeSend(System.currentTimeMillis());
        sendMsgBroad(message);
        return message;
    }

    public void sendMsgBroad(ChatMessage message) {
        Intent intent = new Intent();
        intent.setAction(Constants.ACTIONS.ACTION_SEND_RECEIVER);
        intent.setPackage(getPresenterContext().getPackageName());
        intent.putExtra(Constants.KEYS.KEY_MESSAGE_TARGET, message.getToUserId());
        intent.putExtra(Constants.KEYS.KEY_MESSAGE_CONTENT, message.toJsonString());
        getPresenterContext().sendBroadcast(intent);
    }


    public Friend buildAddFriendMessage(String userId,String userName,int status){
        Friend friend = new Friend();
        friend.setUserId(userId);
        friend.setUserName(userName);
        if(status == MessageTypeEnum.HELLO.getType()){
            friend.setAction("等待验证");
            friend.setStatus(Friend.STATUS_10);
        }else if(status == MessageTypeEnum.BE_FRIEND.getType()){
            friend.setAction("添加成功");
            friend.setStatus(Friend.STATUS_22);
        }

        friend.setRead(true);
        friend.setTimeCreate(System.currentTimeMillis());
        return friend;
    }

}
