package com.rv.im.friend;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.im.ImSetting;
import com.rv.im.R;
import com.rv.im.bean.AddResultBean;
import com.rv.im.db.service.ChatMessageServiceImp;
import com.rv.im.db.service.FriendServiceImp;
import com.rv.im.db.table.ChatMessage;
import com.rv.im.listener.NoDoubleClickListener;
import com.rv.im.presenter.RealAddFriendPresenter;
import com.rv.im.xmpp.ListenerManager;
import com.rv.im.xmpp.listener.ChatMessageListener;
import com.rv.im.xmpp.listener.NewFriendListener;

public class RealAddFriendActivity extends BaseStatusActivity<RealAddFriendPresenter> implements NewFriendListener {

    private static final String KEY_USER_ID = "userid";
    private static final String KEY_ADD_TYPE = "addtype";
    private static final String KEY_USER_NAME = "username";

    private EditText edtAddApply;
    private EditText edtAddRemark;

    private String userId;
    private String userName;
    private int fromAddType;

    public static Intent getIntent(Context context, String userId, String userName, int fromAddType) {
        Intent intent = new Intent(context, RealAddFriendActivity.class);
        intent.putExtra(KEY_USER_ID, userId);
        intent.putExtra(KEY_ADD_TYPE, fromAddType);
        intent.putExtra(KEY_USER_NAME, userName);
        return intent;
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_real_add_friend;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("申请添加朋友");
        titleView.setText(R.id.tv_title_right, "发送");
        ((TextView) titleView.findViewById(R.id.tv_title_right)).setTextColor(Color.WHITE);
        titleView.findViewById(R.id.tv_title_right).setBackgroundResource(R.drawable.bg_btn_green_pre);
        titleView.setChildClickListener(R.id.tv_title_right, new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View view) {
                mPresenter.addFriend(userId, fromAddType);
            }
        });
        ListenerManager.getInstance().addNewFriendListener(this);
        userId = intent.getStringExtra(KEY_USER_ID);
        fromAddType = intent.getIntExtra(KEY_ADD_TYPE, 6);
        userName = intent.getStringExtra(KEY_USER_NAME);
        edtAddApply = findViewById(R.id.edt_add_apply);
        edtAddRemark = findViewById(R.id.edt_add_remark);
        edtAddApply.setText((!TextUtils.isEmpty(ImSetting.getUserName())) ? "我是" + ImSetting.getUserName() : "你好");
        if (!TextUtils.isEmpty(userName))
            edtAddRemark.setText(userName);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        ListenerManager.getInstance().removeNewFriendListener(this);
    }

    private int isyanzheng;

    private String addhaoyouid;

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                if (result != null) {
                    AddResultBean bean = (AddResultBean) result;
                    if (bean.resultCode == 1 && bean.getData() != null) {
                        if (bean.getData().getType() == 1 || bean.getData().getType() == 3) {
                            isyanzheng = 0;// 需要验证
                            // 需要验证就发送打招呼的消息，
                            ChatMessage message = mPresenter.doSayHello(edtAddApply.getText().toString().trim(), userName, userId);
                            addhaoyouid = message != null ? message.getPackId() : "";
                        } else if (bean.getData().getType() == 2 || bean.getData().getType() == 4) {// 已经是好友了
                            isyanzheng = 1;// 不需要验证
                            ChatMessage message = mPresenter.doSayAddFriend(userName, userId);
                            addhaoyouid = message != null ? message.getPackId() : "";
                        } else if (bean.getData().getType() == 5) {
                            showToast(getString(R.string.add_attention_failed));
                        }
                    }
                }
                break;
        }
    }

    // xmpp消息发送成功最终回调到这，
    // 在这里调整ui,
    // 还有存本地数据库，
    public void msgSendSuccess(ChatMessage message, String packet) {
        if (addhaoyouid != null && addhaoyouid.equals(packet)) {
            if (isyanzheng == 0) {// 需要验证
                showToast("打招呼成功，静候回音");
                FriendServiceImp.getInstance(this).addMessage(mPresenter.buildAddFriendMessage(userId, userName, message.getMessageType()));
                setResult(RESULT_OK);
//                ListenerManager.getInstance().notifyNewFriend(mLoginUserId, message, true);
            } else if (isyanzheng == 1) {
                showToast("好友添加成功");
                // 数据库中添加好友
                FriendServiceImp.getInstance(this).addMessage(mPresenter.buildAddFriendMessage(userId, userName, message.getMessageType()));
                ChatMessageServiceImp.getInstance(this).addMessage(message);
                setResult(RESULT_OK);
                finish();
            }
        }
    }

    public void msgSendFailed(String packet) {
        showToast(getString(R.string.add_friend_failed));
    }

    @Override
    public void onNewFriendSendStateChange(String toUserId, ChatMessage message, int messageState) {
        if (messageState == ChatMessageListener.MESSAGE_SEND_SUCCESS) {
            msgSendSuccess(message, message.getPackId());
        } else if (messageState == ChatMessageListener.MESSAGE_SEND_FAILED) {
            msgSendFailed(message.getPackId());
        }
    }

    @Override
    public boolean onNewFriend(ChatMessage message) {
        return false;
    }
}
