package com.rv.im.friend;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.widget.LinearLayout;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.im.R;
import com.rv.im.UserDetailActivity;
import com.rv.im.adapter.AddRecordListAdapter;
import com.rv.im.db.service.FriendServiceImp;
import com.rv.im.db.table.ChatMessage;
import com.rv.im.db.table.Friend;
import com.rv.im.presenter.NewFriendPresenter;
import com.rv.im.xmpp.ListenerManager;
import com.rv.im.xmpp.listener.NewFriendListener;

import java.util.Collections;
import java.util.List;


/*********
 *
 * 新朋友activity
 *
 */
public class NewFriendActivity extends BaseStatusActivity<NewFriendPresenter> implements NewFriendListener {

    private static final int REQUEST_CODE_SEARCH_FRIEND = 10000;

    private LinearLayout llSearch;
    private RecyclerView recyclerView;
    private AddRecordListAdapter listAdapter;

    private List<Friend> addFriendRecords;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ListenerManager.getInstance().addNewFriendListener(this);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    public void onShowError(String errorMsg, int errorType) {
        super.onShowError(errorMsg, errorType);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_new_friend;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {

        titleView.setTitle("新的朋友");
        llSearch = findViewById(R.id.ll_search);
        llSearch.setOnClickListener(v -> {
            Intent in = new Intent(NewFriendActivity.this, AddFriendActivity.class);
            startActivityForResult(in, REQUEST_CODE_SEARCH_FRIEND);
        });

        recyclerView = findViewById(R.id.recyclerview);
        recyclerView.setLayoutManager(new LinearLayoutManager(this, LinearLayout.VERTICAL, false));
        listAdapter = new AddRecordListAdapter(null);
        listAdapter.setListener(listener);
        recyclerView.setAdapter(listAdapter);
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        getAddRecord();
    }

    private void getAddRecord() {
        addFriendRecords = FriendServiceImp.getInstance(this).getAllFriends();

        Collections.sort(addFriendRecords, (o1, o2) -> (int) (-o1.getTimeCreate() + o2.getTimeCreate()));

        if (addFriendRecords != null) {
            listAdapter.setNewData(addFriendRecords);
        }
    }

    @Override
    public void onNewFriendSendStateChange(String toUserId, ChatMessage message, int messageState) {

    }

    @Override
    public boolean onNewFriend(ChatMessage message) {
        getAddRecord();
        return false;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        ListenerManager.getInstance().removeNewFriendListener(this);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == REQUEST_CODE_SEARCH_FRIEND) {
            getAddRecord();
        }
    }

    private Friend agreeFriend;
    private AddRecordListAdapter.FriendItemClickListener listener = new AddRecordListAdapter.FriendItemClickListener() {
        @Override
        public void showDetail(Friend item) {
            UserDetailActivity.start(getApplicationContext(),item.getUserId());
        }

        @Override
        public void agree(Friend item) {
            agreeFriend = item;
            mPresenter.doAgreeOrAttention(agreeFriend,attentionListener);
        }
    };

    private NewFriendPresenter.AttentionListener attentionListener = new NewFriendPresenter.AttentionListener() {
        @Override
        public void success() {
            getAddRecord();
        }

        @Override
        public void failed() {

        }
    } ;
}
