package com.rv.im.friend;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.im.ImSetting;
import com.rv.im.R;
import com.rv.im.UserDetailActivity;
import com.rv.im.adapter.FriendSearchListAdapter;
import com.rv.im.bean.AddResultBean;
import com.rv.im.bean.FriendSearchBean;
import com.rv.im.db.table.ChatMessage;
import com.rv.im.presenter.AddFriendPresenter;
import com.rv.im.xmpp.ListenerManager;
import com.rv.im.xmpp.listener.NewFriendListener;

/*******
 *
 * 添加好友功能
 *
 */
public class AddFriendActivity extends BaseStatusActivity<AddFriendPresenter> implements NewFriendListener {

    private EditText edtSearch;
    private Button btnSearch;

    private RecyclerView recyclerview;

    private FriendSearchListAdapter adapter;

    private String mKeyWord;

    private String userId;
    private String userName;

    private String addhaoyouid = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ListenerManager.getInstance().addNewFriendListener(this);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        ListenerManager.getInstance().removeNewFriendListener(this);
        setResult(RESULT_OK);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_add_friend;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("添加好友");
        btnSearch = findViewById(R.id.btn_search);
        edtSearch = findViewById(R.id.edt_search);
        recyclerview = findViewById(R.id.recyclerview);
        recyclerview.setLayoutManager(new LinearLayoutManager(this, LinearLayout.VERTICAL, false));
        adapter = new FriendSearchListAdapter(null);
        adapter.setListener(new FriendSearchListAdapter.FriendItemClickListener() {
            @Override
            public void showDetail(FriendSearchBean.FriendSearItemBean item) {
                if (item != null) {
                    int fromAddType;
                    if (!TextUtils.isEmpty(userName) && userName.contains(mKeyWord)) {
                        fromAddType = 5;
                    } else {
                        // 昵称不包含关键字的话就是通过手机号搜索出来的，
                        fromAddType = 4;
                    }
                    UserDetailActivity.start(getApplicationContext(), item.getUserId(),fromAddType);
                }
            }

            @Override
            public void add(FriendSearchBean.FriendSearItemBean item) {
                int fromAddType;
                if (!TextUtils.isEmpty(userName) && userName.contains(mKeyWord)) {
                    fromAddType = 5;
                } else {
                    // 昵称不包含关键字的话就是通过手机号搜索出来的，
                    fromAddType = 4;
                }
                userId = item.getUserId();
                userName = item.getNickname();
                startActivityForResult(RealAddFriendActivity.getIntent(getApplicationContext(), userId, userName, fromAddType), 10000);

            }
        });
        recyclerview.setAdapter(adapter);
        btnSearch.setOnClickListener(v -> {
            mKeyWord = edtSearch.getText().toString().trim();
            mPresenter.search(mKeyWord);
        });
    }

    private int isyanzheng = 0;// 该好友是否需要验证

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                FriendSearchBean searchBean = (FriendSearchBean) result;
                if (searchBean != null && searchBean.resultCode == 1 && searchBean.getData() != null && searchBean.getData().size() > 0) {
                    adapter.setNewData(searchBean.getData());
                }
                break;
            case 1:
                AddResultBean addResultBean = (AddResultBean) result;

                if (addResultBean.resultCode == 1 && addResultBean.getData() != null) {
                    if (addResultBean.getData().getType() == 1 || addResultBean.getData().getType() == 3) {
                        isyanzheng = 0;// 需要验证
                        // 需要验证就发送打招呼的消息，
                        ChatMessage message = mPresenter.doSayHello(null, userName, userId);
                        addhaoyouid = message != null ? message.getPackId() : "";
                    } else if (addResultBean.getData().getType() == 2 || addResultBean.getData().getType() == 4) {// 已经是好友了
                        isyanzheng = 1;// 不需要验证
                        ChatMessage message = mPresenter.doSayAddFriend(userName, userId);
                        addhaoyouid = message != null ? message.getPackId() : "";

                    } else if (addResultBean.getData().getType() == 5) {
                        showToast(getString(R.string.add_attention_failed));
                    }
                }
                break;
        }
    }

    @Override
    public void onNewFriendSendStateChange(String toUserId, ChatMessage message, int messageState) {

    }

    @Override
    public boolean onNewFriend(ChatMessage message) {
//        if(message.getMessageType() == MessageTypeEnum)
        return false;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 10000 && resultCode == RESULT_OK) {
            setResult(RESULT_OK);
            finish();
        }
    }
}
