package com.rv.im.db.table;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;

@DatabaseTable(tableName = "tb_friend")
public class Friend {

    // -1:黑名单；0：陌生人；1:单方关注；2:互为好友；8:显示系统号；9:非显示系统号
    public static final int STATUS_BLACKLIST = -1;// 黑名单
    public static final int STATUS_UNKNOW = 0;// 陌生人(不可能出现在好友表，只可能在新朋友消息表)
    public static final int STATUS_ATTENTION = 1;// 关注
    public static final int STATUS_FRIEND = 2;// 好友
    public static final int STATUS_SYSTEM = 8;// 显示系统号
    // 需要验证的
    public static final int STATUS_10 = 10; //显示  等待验证
    public static final int STATUS_11 = 11; //您好
    public static final int STATUS_12 = 12; //已通过验证
    public static final int STATUS_13 = 13; //验证被通过了
    public static final int STATUS_14 = 14; //别人回话
    public static final int STATUS_15 = 15; //回话
    public static final int STATUS_16 = 16; //已删除了XXX
    public static final int STATUS_17 = 17; //XXX删除了我
    public static final int STATUS_18 = 18; //已拉黑了XXX
    public static final int STATUS_19 = 19; //XXX拉黑了我
    public static final int STATUS_20 = 20; //默认值什么都不显示
    // 不需要验证的
    public static final int STATUS_21 = 21;//XXX 添加你为好友
    public static final int STATUS_22 = 22;//你添加好友 XXX
    public static final int STATUS_24 = 24;//XXX 已经取消了黑名单
    public static final int STATUS_23 = 23;//对方把我加入了黑名单
    public static final int STATUS_25 = 25;//通过手机联系人添加
    public static final int STATUS_26 = 26;//被后台删除的好友，仅用于新的朋友页面显示，

    @DatabaseField(columnName = "_id", dataType = DataType.INTEGER, generatedId = true)
    private int id;
    @DatabaseField(columnName = "userId")
    private String userId;
    @DatabaseField(columnName = "userName")
    private String userName;
    @DatabaseField(columnName = "action")
    private String action ;
    @DatabaseField(columnName = "timeCreate")
    private long timeCreate ; // 发起时间
    @DatabaseField
    private int status ;// -1:黑名单；0：陌生人；1:发卡了i；2:互为好友；3 拒绝 ；8:系统号；9:非显示系统号

    @DatabaseField
    private String privacy;// 隐私

    @DatabaseField
    private String remarkName;// 备注

    @DatabaseField
    private String describe;// 描述，

    @DatabaseField
    private boolean isRead ;

    @DatabaseField
    private int version;// 本地表的版本

    // 消息免打扰 0:未设置 1:已设置
    @DatabaseField(defaultValue = "0")
    private int offlineNoPushMsg;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public long getTimeCreate() {
        return timeCreate;
    }

    public void setTimeCreate(long timeCreate) {
        this.timeCreate = timeCreate;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getPrivacy() {
        return privacy;
    }

    public void setPrivacy(String privacy) {
        this.privacy = privacy;
    }

    public String getRemarkName() {
        return remarkName;
    }

    public void setRemarkName(String remarkName) {
        this.remarkName = remarkName;
    }

    public String getDescribe() {
        return describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getOfflineNoPushMsg() {
        return offlineNoPushMsg;
    }

    public void setOfflineNoPushMsg(int offlineNoPushMsg) {
        this.offlineNoPushMsg = offlineNoPushMsg;
    }

    public boolean isRead() {
        return isRead;
    }

    public void setRead(boolean read) {
        isRead = read;
    }
}
