package com.rv.im.db.service;

import android.content.Context;

import com.rv.im.db.dao.ConversationDao;
import com.rv.im.db.dao.FriendDao;
import com.rv.im.db.dao.MessageDao;
import com.rv.im.db.table.Friend;

import java.util.List;

public class FriendServiceImp implements IFriendService {

    private FriendDao dao = null;

    private static FriendServiceImp instance = null ;

    private FriendServiceImp(Context context) {
        dao = FriendDao.getInstance(context);
    }


    public static FriendServiceImp getInstance(Context context) {
        if (instance == null) {
            instance = new FriendServiceImp(context.getApplicationContext());
        }
        return instance;
    }


    @Override
    public void addMessage(Friend friend) {
        dao.addMessage(friend);
    }

    @Override
    public List<Friend> getAllFriends() {
        return dao.getFriendList();
    }

    @Override
    public Friend getFriend(String user) {
        return null;
    }
}
