package com.rv.im.db.dao;

import android.content.Context;
import android.util.Log;

import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.rv.im.db.SQLiteHelper;
import com.rv.im.db.table.Customer;
import com.rv.im.db.table.Friend;
import com.rv.im.log.LogUtil;

import java.sql.SQLException;
import java.util.List;

public class FriendDao {

    private static final String TAG = ConversationDao.class.getSimpleName();
    private static FriendDao instance = null;
    public Dao<Friend, Integer> dao;
    private Context mContext;

    private FriendDao(Context context) {
        try {
            this.mContext = context;
            dao = DaoManager.createDao(SQLiteHelper.getInstance(context).getConnectionSource(), Friend.class);
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static final FriendDao getInstance(Context context) {
        if (instance == null) {
            synchronized (FriendDao.class) {
                if (instance == null) {
                    instance = new FriendDao(context);
                }
            }
        }
        return instance;
    }

    public void clear() {
        instance = null;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        OpenHelperManager.releaseHelper();
    }

    public void makeMessageRead(Friend friend) {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return;
        }
        if (friend == null) {
            LogUtil.e(TAG, "friend is null");
            return;
        }
        try {
            dao.update(friend);
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /******
     * 添加一条添加好友的记录
     * @param friend
     */
    public void addMessage(Friend friend) {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return;
        }
        if (friend == null) {
            LogUtil.e(TAG, "friend is null");
            return;
        }
        Log.d(TAG, friend.toString());
        Friend oldFriend = null;
        if ((oldFriend = isExit(friend)) != null) {
            updateFriend(friend, oldFriend);
            return;
        }
        try {
            int result = dao.create(friend);
            LogUtil.d(TAG, "插入结果 " + result);
        } catch (SQLException e) {
            e.printStackTrace();
            LogUtil.d(TAG, "插入失败 " + e.getMessage());
        }
    }

    /*******
     *
     * 查询好友列表
     *
     * @return
     */
    public List<Friend> getFriendList() {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return null;
        }
        List<Friend> friendList = null;
        try {
            friendList = dao.queryBuilder().where().eq("status", Friend.STATUS_10)
                    .or().eq("status", Friend.STATUS_11)
                    .or().eq("status", Friend.STATUS_12)
                    .or().eq("status", Friend.STATUS_13)
                    .or().eq("status", Friend.STATUS_21)
                    .or().eq("status", Friend.STATUS_22)
                    .query();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return friendList;
    }

    /*****
     * 更新消息
     * @param friend
     */
    public int updateFriend(Friend friend, Friend old) {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return -1;
        }
        if (friend == null) {
            LogUtil.e(TAG, "friend is null");
            return -1;
        }
        if (old == null) {
            LogUtil.e(TAG, "old is null");
            return -1;
        }
        update(friend, old);
        int result = 0 ;
        try {
            result  = dao.update(old);
//            dao.update(friend);
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return result ;
    }

    private void update(Friend f1, Friend f2) {
        f2.setStatus(f1.getStatus());
        f2.setTimeCreate(f1.getTimeCreate());
        f2.setAction(f1.getAction());
        f2.setRead(f1.isRead());
    }

    /*******
     * 判断是否存在好友记录
     * @param friend
     * @return
     */
    public Friend isExit(Friend friend) {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return null;
        }
        if (friend == null) {
            LogUtil.e(TAG, "friend is null");
            return null;
        }
        try {
            List<Friend> lists = dao.queryForEq("userId", friend.getUserId());
            return lists == null ? null : lists.size() == 0 ? null : lists.get(0);
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }
}
