package com.rv.im.bean;

import android.text.TextUtils;

import com.rv.im.util.sortlist.PingYinUtil;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ContactsBean extends ImBaseBean implements Serializable {

    private long currentTime;
    private List<ContactItemBean> data;

    public long getCurrentTime() {
        return currentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public List<ContactItemBean> getData() {
        return data;
    }

    public void setData(List<ContactItemBean> data) {
        this.data = data;
    }

    public static class ContactItemBean implements Serializable, Comparable<ContactItemBean> {
        private int blacklist; //  0 表示不是黑名单，1表示是在黑名单
        private double chatRecordTimeOut; //0 || -1 消息永久保存 单位：day
        private long createTime;
        private int encryptType;
        private int fromAddType;
        private int isBeenBlack;  // 1表示对方将我拉入黑名单
        private int isOpenSnapchat;
        private int lastTalkTime;
        private int modifyTime; // 修改时间
        private int msgNum;
        private int offlineNoPushMsg;  // 消息免打扰
        private int openTopChatTime;
        private int status;
        private String toNickname;
        private String toUserId;// 被关注的人
        private int toUserType;// 2 公众号
        private int userId;// 发起关注的人
        private int type = 1;
        private int localHead;

        public int getBlacklist() {
            return blacklist;
        }

        public void setBlacklist(int blacklist) {
            this.blacklist = blacklist;
        }

        public double getChatRecordTimeOut() {
            return chatRecordTimeOut;
        }

        public void setChatRecordTimeOut(double chatRecordTimeOut) {
            this.chatRecordTimeOut = chatRecordTimeOut;
        }

        public long getCreateTime() {
            return createTime;
        }

        public void setCreateTime(long createTime) {
            this.createTime = createTime;
        }

        public int getEncryptType() {
            return encryptType;
        }

        public void setEncryptType(int encryptType) {
            this.encryptType = encryptType;
        }

        public int getFromAddType() {
            return fromAddType;
        }

        public void setFromAddType(int fromAddType) {
            this.fromAddType = fromAddType;
        }

        public int getIsBeenBlack() {
            return isBeenBlack;
        }

        public void setIsBeenBlack(int isBeenBlack) {
            this.isBeenBlack = isBeenBlack;
        }

        public int getIsOpenSnapchat() {
            return isOpenSnapchat;
        }

        public void setIsOpenSnapchat(int isOpenSnapchat) {
            this.isOpenSnapchat = isOpenSnapchat;
        }

        public int getLastTalkTime() {
            return lastTalkTime;
        }

        public void setLastTalkTime(int lastTalkTime) {
            this.lastTalkTime = lastTalkTime;
        }

        public int getModifyTime() {
            return modifyTime;
        }

        public void setModifyTime(int modifyTime) {
            this.modifyTime = modifyTime;
        }

        public int getMsgNum() {
            return msgNum;
        }

        public void setMsgNum(int msgNum) {
            this.msgNum = msgNum;
        }

        public int getOfflineNoPushMsg() {
            return offlineNoPushMsg;
        }

        public void setOfflineNoPushMsg(int offlineNoPushMsg) {
            this.offlineNoPushMsg = offlineNoPushMsg;
        }

        public int getOpenTopChatTime() {
            return openTopChatTime;
        }

        public void setOpenTopChatTime(int openTopChatTime) {
            this.openTopChatTime = openTopChatTime;
        }

        public int getStatus() {
            return status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getToNickname() {
            return toNickname;
        }

        public void setToNickname(String toNickname) {
            this.toNickname = toNickname;
        }

        public String getToUserId() {
            return toUserId;
        }

        public void setToUserId(String toUserId) {
            this.toUserId = toUserId;
        }

        public int getToUserType() {
            return toUserType;
        }

        public void setToUserType(int toUserType) {
            this.toUserType = toUserType;
        }

        public int getUserId() {
            return userId;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getLocalHead() {
            return localHead;
        }

        public void setLocalHead(int localHead) {
            this.localHead = localHead;
        }

//        @Override
//        public boolean equals(Object obj) {
//            ContactItemBean bean = (ContactItemBean) obj;
//            return !TextUtils.isEmpty(getToUserId()) && !TextUtils.isEmpty(bean.getToUserId()) ? getToUserId().equals(bean.getToUserId()) : false;
//        }
//
//        @Override
//        public int hashCode() {
//            return !TextUtils.isEmpty(getToUserId()) ? getToUserId().hashCode() : super.hashCode();
//        }

        @Override
        public int compareTo(ContactItemBean o) {
            String pingyin = PingYinUtil.getPingYin(o.getToNickname());
            String pingy = PingYinUtil.getPingYin(this.getToNickname());
            if (!TextUtils.isEmpty(pingy) && !TextUtils.isEmpty(pingyin)) {
                return pingy.compareTo(pingyin);
            }
            return 0;
        }
    }
}

