package com.rv.im.adapter;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.im.R;
import com.rv.im.bean.ContactsBean;
import com.rv.im.bean.FriendSearchBean;
import com.rv.im.util.NetworkUtil;

import java.util.List;

public class FriendSearchListAdapter extends BaseQuickAdapter<FriendSearchBean.FriendSearItemBean, BaseViewHolder> {

    private FriendItemClickListener listener;

    public FriendSearchListAdapter(@Nullable List<FriendSearchBean.FriendSearItemBean> data) {

        super(R.layout.item_friend_view, data);
    }

    public void setListener(FriendItemClickListener listener) {
        this.listener = listener;
    }

    @Override
    protected void convert(BaseViewHolder helper, FriendSearchBean.FriendSearItemBean item) {

        helper.setImageResource(R.id.img_header, R.drawable.icon_lion);
        helper.setText(R.id.tv_name, TextUtils.isEmpty(item.getNickname()) ? " " : item.getNickname());

        LinearLayout llContent = helper.itemView.findViewById(R.id.ll_content) ;
        llContent.setOnClickListener(v -> {
            if (listener != null) {
                listener.showDetail(item);
            }
        });
        helper.setOnClickListener(R.id.btn_add, v -> {
            if (listener != null) {
                listener.add(item);
            }
        });
    }


    public interface FriendItemClickListener {
        void showDetail(FriendSearchBean.FriendSearItemBean item);

        void add(FriendSearchBean.FriendSearItemBean item);
    }
}
