package com.rv.im.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.ruiwenliu.wrapper.bean.UserInfoBean;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.DisplayUtil;
import com.rv.component.utils.RvCache;
import com.rv.im.ChatHolderFactory;
import com.rv.im.R;
import com.rv.im.audio_x.VoiceAnimView;
import com.rv.im.audio_x.VoicePlayer;
import com.rv.im.db.service.ChatMessageServiceImp;
import com.rv.im.db.service.IChatMessageService;
import com.rv.im.db.table.ChatMessage;
import com.rv.im.glide.GlideOptions;
import com.rv.im.glide.TransformationUtils;
import com.rv.im.util.DateUtils;
import com.rv.im.util.SmileyParser;
import com.rv.im.view.CycleProgress;
import com.rv.im.view.RoundImageView;

import java.util.Date;
import java.util.List;

public class ChatContentAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private Context mContext;
    private List<ChatMessage> messageList;
    private String mLoginUserId;
    private SmileyParser parser;
    private OnClickItemListener listener;
    private String myHeaderUrl;

    public interface OnClickItemListener {

        void onClick(int resId, ChatMessage message);

        void reSend(ChatMessage message);

        void voicePlay(ChatMessage message);

        void call(boolean isVoice);

        /******
         * 撤销
         * @param message
         */
        void sendCancel(ChatMessage message);
    }

    public ChatContentAdapter(Context context, String mLoginUserId, List<ChatMessage> list, OnClickItemListener listener) {

        UserInfoBean userInfoBean = (UserInfoBean) RvCache.getInstance().get(CacheEnum.USER);
        myHeaderUrl = userInfoBean.getData().getHeadimgurl();
        this.mContext = context;
        this.mLoginUserId = mLoginUserId;
        this.messageList = list;
        this.parser = SmileyParser.getInstance(mContext);
        this.listener = listener;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        switch (i) {
            case 10:
                return new MsgFromTextHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_from_item_text, viewGroup, false));
            case 11:
                return new MsgToTextHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_to_item_text, viewGroup, false));
            case 20:
                return new MsgFromCardHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_from_item_card, viewGroup, false));
            case 21:
                return new MsgToCardHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_to_item_card, viewGroup, false));
            case 30:
                return new MsgFromPicHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_from_item_pic, viewGroup, false));
            case 31:
                return new MsgToPicHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_to_item_pic, viewGroup, false));
            case 40:
                return new MsgFromVoiceHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_from_item_voice, viewGroup, false));
            case 41:
                return new MsgToVoiceHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_to_item_voice, viewGroup, false));
            case 50:
                return new MsgFromVolteCallHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_from_item_volte_call, viewGroup, false));
            case 51:
                return new MsgToVolteCallHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_to_item_volte_call, viewGroup, false));
            case 60:
                return new MsgFromVideoCallHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_from_item_video_call, viewGroup, false));
            case 61:
                return new MsgToVideoCallHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_to_item_video_call, viewGroup, false));
            case 70:
                return new MsgBePassHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_be_pass_item, viewGroup, false));
            case 71:
                return new MsgPassHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_pass_item, viewGroup, false));
            case 72:
                return new MsgAddSuccessHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_pass_item, viewGroup, false));
            case 73:
                return new MsgBeFriendHolder(LayoutInflater.from(mContext).inflate(R.layout.chat_be_pass_item, viewGroup, false));
        }
        return null;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {
        ChatMessage bean = messageList.get(i);
        if (bean != null) {
            if (viewHolder instanceof MsgToTextHolder) {
                setToTextContentView(bean, (MsgToTextHolder) viewHolder);
            } else if (viewHolder instanceof MsgFromTextHolder) {
                setFromTextContentView(bean, (MsgFromTextHolder) viewHolder);
            } else if (viewHolder instanceof MsgToPicHolder) {
                setToPicContentView(bean, (MsgToPicHolder) viewHolder);
            } else if (viewHolder instanceof MsgFromPicHolder) {
                setFromPicContentView(bean, (MsgFromPicHolder) viewHolder);
            } else if (viewHolder instanceof MsgToVoiceHolder) {
                setToVoiceContentView(bean, (MsgToVoiceHolder) viewHolder);
            } else if (viewHolder instanceof MsgFromVoiceHolder) {
                setFromVoiceContentView(bean, (MsgFromVoiceHolder) viewHolder);
            } else if (viewHolder instanceof MsgFromVolteCallHolder) {
                setFromVolteCallContentView(bean, (MsgFromVolteCallHolder) viewHolder);
            } else if (viewHolder instanceof MsgToVolteCallHolder) {
                setToVolteCallContentView(bean, (MsgToVolteCallHolder) viewHolder);
            } else if (viewHolder instanceof MsgFromCardHolder) {
                setFromCardContentView(bean, (MsgFromCardHolder) viewHolder);
            } else if (viewHolder instanceof MsgToCardHolder) {
                setToCardContentView(bean, (MsgToCardHolder) viewHolder);
            } else if (viewHolder instanceof MsgFromVideoCallHolder) {
                setFromVideoCallContentView(bean, (MsgFromVideoCallHolder) viewHolder);
            } else if (viewHolder instanceof MsgToVideoCallHolder) {
                setToVideoCallContentView(bean, (MsgToVideoCallHolder) viewHolder);
            } else if (viewHolder instanceof MsgBePassHolder) {
                setBePassContentView(bean, (MsgBePassHolder) viewHolder) ;
            } else if (viewHolder instanceof MsgPassHolder) {
                setPassContentView(bean, (MsgPassHolder) viewHolder) ;
            } else if (viewHolder instanceof MsgBeFriendHolder) {
                setBeFriendContentView(bean, (MsgBeFriendHolder) viewHolder);
            } else if (viewHolder instanceof MsgAddSuccessHolder) {
                setMsgAddSuccessContentView(bean, (MsgAddSuccessHolder) viewHolder);
            }
        }
    }

    private void setFromVolteCallContentView(ChatMessage bean, MsgFromVolteCallHolder holder) {

        showTime(holder.tvSendTime, bean);
        String content = dealMessageContent(bean.getTimeLen(), bean.getContent());
        holder.chatText.setText(content);
        holder.chatText.setOnClickListener(v -> {
            if (listener != null) {
                listener.call(true);
            }
        });
    }


    private void setFromVideoCallContentView(ChatMessage bean, MsgFromVideoCallHolder holder) {

        showTime(holder.tvSendTime, bean);
        String content = dealMessageContent(bean.getTimeLen(), bean.getContent());
//        holder.chatText.setText(bean.getContent());
        holder.chatText.setText(content);

        holder.chatText.setOnClickListener(v -> {
            if (listener != null) {
                listener.call(false);
            }
        });
    }


    private void setToVolteCallContentView(ChatMessage bean, MsgToVolteCallHolder holder) {

        showTime(holder.tvSendTime, bean);
        String content = dealMessageContent(bean.getTimeLen(), bean.getContent());
        holder.chatText.setText(content);
        holder.chatText.setOnClickListener(v -> {
            if (listener != null) {
                listener.call(true);
            }
        });

        if (!TextUtils.isEmpty(myHeaderUrl)) {
            GlideManager.getInstance(mContext).loadImage(myHeaderUrl, holder.ivHeader);
        }
    }

    private void setToVideoCallContentView(ChatMessage bean, MsgToVideoCallHolder holder) {

        showTime(holder.tvSendTime, bean);
        String content = dealMessageContent(bean.getTimeLen(), bean.getContent());
        holder.chatText.setText(content);
        holder.chatText.setOnClickListener(v -> {
            if (listener != null) {
                listener.call(false);
            }
        });
        if (!TextUtils.isEmpty(myHeaderUrl)) {
            GlideManager.getInstance(mContext).loadImage(myHeaderUrl, holder.ivHeader);
        }
    }

    private void setBePassContentView(ChatMessage bean, MsgBePassHolder holder) {
        showTime(holder.tvSendTime, bean);
        holder.chatText.setText("我通过了你的朋友验证请求，现在我们开始可以聊天了");
    }

    private void setBeFriendContentView(ChatMessage bean, MsgBeFriendHolder holder) {
        showTime(holder.tvSendTime, bean);
        holder.chatText.setText("我已添加你为好友，现在我们开始可以聊天了");
    }


    private void setMsgAddSuccessContentView(ChatMessage bean, MsgAddSuccessHolder holder) {
        showTime(holder.tvSendTime, bean);
        holder.chatText.setText("我已添加你为好友，现在我们开始可以聊天了");
        if (!TextUtils.isEmpty(myHeaderUrl)) {
            GlideManager.getInstance(mContext).loadImage(myHeaderUrl, holder.ivHeader);
        }
    }


    private void setPassContentView(ChatMessage bean, MsgPassHolder holder) {

        showTime(holder.tvSendTime, bean);
        holder.chatText.setText("我通过了你的朋友验证请求，现在我们开始可以聊天了");
        if (!TextUtils.isEmpty(myHeaderUrl)) {
            GlideManager.getInstance(mContext).loadImage(myHeaderUrl, holder.ivHeader);
        }
    }

    private void setToTextContentView(ChatMessage bean, MsgToTextHolder holder) {
        showTime(holder.tvSendTime, bean);
        holder.chatText.setText(parser.addSmileySpans(deleteHtml(bean.getContent()), true));
        if (bean.getMessageStatus() == 0) {
            holder.progressBar.setVisibility(View.VISIBLE);
            holder.ivFailed.setVisibility(View.GONE);
            holder.tvRead.setVisibility(View.GONE);
        } else if (bean.getMessageStatus() == 1) {
            holder.progressBar.setVisibility(View.GONE);
            holder.ivFailed.setVisibility(View.GONE);
            holder.tvRead.setVisibility(View.VISIBLE);
        } else if (bean.getMessageStatus() == 2) {
            holder.progressBar.setVisibility(View.GONE);
            holder.ivFailed.setVisibility(View.VISIBLE);
            holder.tvRead.setVisibility(View.GONE);
        }
        holder.ivFailed.setOnClickListener(v -> listener.reSend(bean));


//        holder.chatText.setOnLongClickListener(v -> {
//            if (System.currentTimeMillis() - bean.getTimeSend() > 60 * 5 * 1000) {
//                // 删除
//                showPopwindow(0, holder.itemView, bean);
//            } else {
//                // 撤销
//                showPopwindow(1, holder.itemView, bean);
//            }
//            return false;
//        });

        if (!TextUtils.isEmpty(myHeaderUrl)) {
            GlideManager.getInstance(mContext).loadImage(myHeaderUrl, holder.ivHeader);
        }
    }

    private void showPopwindow(int type, View view, ChatMessage message) {
        View contentView = LayoutInflater.from(mContext).inflate(R.layout.view_chat_content_del, null);
        final PopupWindow popupWindow = new PopupWindow(contentView, DisplayUtil.dip2px(mContext, 200f), DisplayUtil.dip2px(mContext, 40f));
        popupWindow.setOutsideTouchable(true);
        popupWindow.setTouchable(true);
        TextView tvDel = contentView.findViewById(R.id.tv_del);
        if (type == 0) {
            tvDel.setText("删除");
        } else {
            tvDel.setText("撤销");
        }
        tvDel.setOnClickListener(v -> {
            if (type == 0) {  /// 删除
                getDbService().deleteMessage(message);
                notifyItemRemoved(messageList.indexOf(message));
                messageList.remove(message);
            } else {    // 撤销
                if (listener != null) {
                    listener.sendCancel(message);
                    notifyItemRemoved(messageList.indexOf(message));
                    messageList.remove(message);
                }
            }
            popupWindow.dismiss();
        });

        popupWindow.showAtLocation(view, Gravity.CENTER_HORIZONTAL, 0, 0);
    }

    public IChatMessageService getDbService() {
        return ChatMessageServiceImp.getInstance(mContext);
    }

    private void setFromTextContentView(ChatMessage bean, MsgFromTextHolder holder) {

        showTime(holder.tvSendTime, bean);
        holder.chatText.setText(parser.addSmileySpans(deleteHtml(bean.getContent()), true));
    }

    private void setFromCardContentView(ChatMessage bean, MsgFromCardHolder holder) {
        showTime(holder.tvSendTime, bean);
        if (!TextUtils.isEmpty(bean.getContent()) && bean.getContent().endsWith("png")
                || bean.getContent().endsWith("jpg") || bean.getContent().endsWith("gif")) {
            GlideOptions options = GlideOptions.placeholderOf(R.mipmap.default_error).
                    error(R.mipmap.default_error).skipMemoryCache(false);
            Glide.with(mContext)
                    .asBitmap()
                    .load(bean.getContent())
                    .apply(options)
                    .into(holder.ivFileIcon);
        } else {
            if (!TextUtils.isEmpty(bean.getContent())) {
                fillFileInco(holder, bean);
            }
        }

        holder.llCard.setOnClickListener(v -> listener.onClick(v.getId(), bean));
        String fileName = null;
        if (!TextUtils.isEmpty(bean.getContent()) && bean.getContent().contains("/")) {
            fileName = bean.getContent().substring(bean.getContent().lastIndexOf("/") + 1);
        }
        if (!TextUtils.isEmpty(fileName)) {
            holder.tvFileName.setText(fileName);
        }
    }


    private void setToCardContentView(ChatMessage bean, MsgToCardHolder holder) {

        showTime(holder.tvSendTime, bean);
        if (bean.getFilePath().endsWith("png") || bean.getFilePath().endsWith("jpg") || bean.getFilePath().endsWith("gif")) {
            GlideOptions options = GlideOptions.placeholderOf(R.mipmap.default_error).
                    error(R.mipmap.default_error).skipMemoryCache(false);
            Glide.with(mContext)
                    .asBitmap()
                    .load(bean.getFilePath())
                    .apply(options)
                    .into(holder.ivFileIcon);
        } else {
            fillFileInco(holder, bean);
        }

        if (!TextUtils.isEmpty(myHeaderUrl)) {
            GlideManager.getInstance(mContext).loadImage(myHeaderUrl, holder.ivHeader);
        }
        String fileName = null;
        if (bean.getFilePath().contains("/")) {
            fileName = bean.getFilePath().substring(bean.getFilePath().lastIndexOf("/") + 1);
        }
        holder.llCard.setOnClickListener(v -> listener.onClick(v.getId(), bean));
        holder.ivFailed.setOnClickListener(v -> listener.reSend(bean));
        if (!TextUtils.isEmpty(fileName)) {
            holder.tvFileName.setText(fileName);
        }
        if (bean.getMessageStatus() == 0) {
            holder.progress.setVisibility(View.VISIBLE);
            holder.ivFailed.setVisibility(View.GONE);
            holder.tvRead.setVisibility(View.GONE);
        } else if (bean.getUpLoadStatus() == 2) { // 上传 成功
            if (bean.getMessageStatus() == 0) {
                holder.progress.setVisibility(View.VISIBLE);
                holder.ivFailed.setVisibility(View.GONE);
                holder.tvRead.setVisibility(View.GONE);
            } else if (bean.getMessageStatus() == 1) {
                holder.progress.setVisibility(View.GONE);
                holder.ivFailed.setVisibility(View.GONE);
                holder.tvRead.setVisibility(View.VISIBLE);
            } else if (bean.getMessageStatus() == 2) {
                holder.progress.setVisibility(View.GONE);
                holder.ivFailed.setVisibility(View.VISIBLE);
                holder.tvRead.setVisibility(View.GONE);
            }

        } else if (bean.getUpLoadStatus() == 3) { // 上传失败
            holder.progress.setVisibility(View.GONE);
            holder.ivFailed.setVisibility(View.VISIBLE);
            holder.tvRead.setVisibility(View.GONE);
        }
    }

    private void setToPicContentView(ChatMessage bean, MsgToPicHolder holder) {
        showTime(holder.tvSendTime, bean);
        if (!TextUtils.isEmpty(bean.getFilePath())) {
            GlideOptions options = GlideOptions.placeholderOf(R.mipmap.default_error).
                    error(R.mipmap.default_error).skipMemoryCache(false);
            Glide.with(mContext)
                    .asBitmap()
                    .load(bean.getFilePath())
                    .apply(options)
                    .apply(RequestOptions.overrideOf(holder.chatPic.getWidth(), holder.chatPic.getHeight()))
                    .into(new TransformationUtils(holder.chatPic));
        }

        if (!TextUtils.isEmpty(myHeaderUrl)) {
            GlideManager.getInstance(mContext).loadImage(myHeaderUrl, holder.ivHeader);
        }

        holder.chatPic.setOnClickListener(v -> listener.onClick(v.getId(), bean));
        holder.ivFailed.setOnClickListener(v -> listener.reSend(bean));

        if (bean.getUpLoadStatus() == 1) {
            holder.progressBar.setVisibility(View.GONE);
            holder.ivFailed.setVisibility(View.GONE);
            holder.tvRead.setVisibility(View.GONE);
            holder.cycleProgress.setVisibility(View.VISIBLE);
            holder.cycleProgress.setmProgress(bean.getUploadSchedule());
        } else if (bean.getUpLoadStatus() == 2) { // 上传 成功
            holder.cycleProgress.setVisibility(View.GONE);
            if (bean.getMessageStatus() == 0) {
                holder.progressBar.setVisibility(View.VISIBLE);
                holder.ivFailed.setVisibility(View.GONE);
                holder.tvRead.setVisibility(View.GONE);
            } else if (bean.getMessageStatus() == 1) {
                holder.progressBar.setVisibility(View.GONE);
                holder.ivFailed.setVisibility(View.GONE);
                holder.tvRead.setVisibility(View.VISIBLE);
            } else if (bean.getMessageStatus() == 2) {
                holder.progressBar.setVisibility(View.GONE);
                holder.ivFailed.setVisibility(View.VISIBLE);
                holder.tvRead.setVisibility(View.GONE);
            }
        } else if (bean.getUpLoadStatus() == 3) { // 上传失败
            holder.progressBar.setVisibility(View.GONE);
            holder.ivFailed.setVisibility(View.VISIBLE);
            holder.tvRead.setVisibility(View.GONE);
            holder.cycleProgress.setVisibility(View.GONE);
        }
    }

    private void setFromPicContentView(ChatMessage bean, MsgFromPicHolder holder) {

        showTime(holder.tvSendTime, bean);
        if (!TextUtils.isEmpty(bean.getContent())) {
            GlideOptions options = GlideOptions.placeholderOf(R.mipmap.default_error).
                    error(R.mipmap.default_error).skipMemoryCache(false);
            Glide.with(mContext)
                    .asBitmap()
                    .load(bean.getContent())
                    .apply(options)
                    .apply(RequestOptions.overrideOf(holder.chatPic.getWidth(), holder.chatPic.getHeight()))
                    .into(new TransformationUtils(holder.chatPic));
        }
        holder.chatPic.setOnClickListener(v -> listener.onClick(v.getId(), bean));
    }

    private void setFromVoiceContentView(ChatMessage bean, MsgFromVoiceHolder holder) {
        showTime(holder.tvSendTime, bean);
        holder.chatVoiceAnimView.setOnClickListener(v -> {
                    VoicePlayer.instance().playVoice(holder.chatVoiceAnimView);
                    ChatMessageServiceImp.getInstance(mContext).setVoicePlay(bean.getPackId());
                    listener.voicePlay(bean);
                    holder.imgState.setVisibility(View.GONE);
                }
        );
        if (!TextUtils.isEmpty(bean.getContent())) {
            holder.chatVoiceAnimView.fillData(bean);
        }
        if (bean.getVoiceStatus() == 0) {
            holder.imgState.setVisibility(View.VISIBLE);
        } else {
            holder.imgState.setVisibility(View.GONE);
        }
    }

    private void setToVoiceContentView(ChatMessage bean, MsgToVoiceHolder holder) {
        showTime(holder.tvSendTime, bean);
        holder.chatVoiceAnimView.setOnClickListener(v ->
                VoicePlayer.instance().playVoice(holder.chatVoiceAnimView));
        if (!TextUtils.isEmpty(bean.getFilePath())) {
            holder.chatVoiceAnimView.fillData(bean);
        }
        if (bean.getMessageStatus() == 0) {
            holder.progress.setVisibility(View.VISIBLE);
            holder.ivFailed.setVisibility(View.GONE);
            holder.tvRead.setVisibility(View.GONE);
        } else if (bean.getUpLoadStatus() == 2) { // 上传 成功
            if (bean.getMessageStatus() == 0) {
                holder.progress.setVisibility(View.VISIBLE);
                holder.ivFailed.setVisibility(View.GONE);
                holder.tvRead.setVisibility(View.GONE);
            } else if (bean.getMessageStatus() == 1) {
                holder.progress.setVisibility(View.GONE);
                holder.ivFailed.setVisibility(View.GONE);
                holder.tvRead.setVisibility(View.VISIBLE);
            } else if (bean.getMessageStatus() == 2) {
                holder.progress.setVisibility(View.GONE);
                holder.ivFailed.setVisibility(View.VISIBLE);
                holder.tvRead.setVisibility(View.GONE);
            }
        } else if (bean.getUpLoadStatus() == 3) { // 上传失败
            holder.progress.setVisibility(View.GONE);
            holder.ivFailed.setVisibility(View.VISIBLE);
            holder.tvRead.setVisibility(View.GONE);
        }
        holder.ivFailed.setOnClickListener(v -> listener.reSend(bean));
        if (!TextUtils.isEmpty(myHeaderUrl)) {
            GlideManager.getInstance(mContext).loadImage(myHeaderUrl, holder.ivHeader);
        }
    }


    @Override
    public int getItemViewType(int position) {
        return ChatHolderFactory.getChatHolderType(mLoginUserId, messageList.get(position));
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return this.messageList == null ? 0 : this.messageList.size();
    }

    class MsgToTextHolder extends RecyclerView.ViewHolder {
        TextView tvSendTime;
        RoundImageView ivHeader;
        TextView chatText;
        ImageView ivFailed;
        ProgressBar progressBar;
        TextView tvRead;

        public MsgToTextHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            chatText = itemView.findViewById(R.id.chat_text);
            ivFailed = itemView.findViewById(R.id.iv_failed);
            progressBar = itemView.findViewById(R.id.progress);
            tvRead = itemView.findViewById(R.id.tv_read);
        }
    }


    class MsgBePassHolder extends RecyclerView.ViewHolder {
        TextView tvSendTime;
        RoundImageView ivHeader;
        TextView chatText;

        public MsgBePassHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            chatText = itemView.findViewById(R.id.chat_text);
        }
    }

    class MsgPassHolder extends RecyclerView.ViewHolder {
        TextView tvSendTime;
        RoundImageView ivHeader;
        TextView chatText;

        public MsgPassHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            chatText = itemView.findViewById(R.id.chat_text);
        }
    }

    class MsgAddSuccessHolder extends RecyclerView.ViewHolder {
        TextView tvSendTime;
        RoundImageView ivHeader;
        TextView chatText;

        public MsgAddSuccessHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            chatText = itemView.findViewById(R.id.chat_text);
        }
    }

    class MsgBeFriendHolder extends RecyclerView.ViewHolder {

        TextView tvSendTime;
        RoundImageView ivHeader;
        TextView chatText;

        public MsgBeFriendHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            chatText = itemView.findViewById(R.id.chat_text);
        }
    }

    class MsgFromTextHolder extends RecyclerView.ViewHolder {
        TextView tvSendTime;
        RoundImageView ivHeader;
        TextView chatText;
        ImageView imgState;

        public MsgFromTextHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            chatText = itemView.findViewById(R.id.chat_text);
            imgState = itemView.findViewById(R.id.img_state);
        }
    }

    class MsgFromPicHolder extends RecyclerView.ViewHolder {

        TextView tvSendTime;
        RoundImageView ivHeader;
        ImageView chatPic;
        ImageView imgState;

        public MsgFromPicHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            chatPic = itemView.findViewById(R.id.chat_pic);
            imgState = itemView.findViewById(R.id.img_state);
        }
    }

    class MsgToPicHolder extends RecyclerView.ViewHolder {

        TextView tvSendTime;
        RoundImageView ivHeader;
        ProgressBar progressBar;
        ImageView chatPic;
        ImageView ivFailed;
        TextView tvRead;
        CycleProgress cycleProgress;

        public MsgToPicHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            chatPic = itemView.findViewById(R.id.chat_pic);
            progressBar = itemView.findViewById(R.id.progress);
            ivFailed = itemView.findViewById(R.id.iv_failed);
            tvRead = itemView.findViewById(R.id.tv_read);
            cycleProgress = itemView.findViewById(R.id.cycle_progress);
        }
    }

    class MsgFromCardHolder extends RecyclerView.ViewHolder {

        TextView tvSendTime;
        RoundImageView ivHeader;
        TextView tvFileName;
        ImageView imgState;
        ImageView ivFileIcon;
        TextView tvType;
        LinearLayout llCard;

        public MsgFromCardHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            tvFileName = itemView.findViewById(R.id.tv_file_name);
            imgState = itemView.findViewById(R.id.img_state);
            ivFileIcon = itemView.findViewById(R.id.iv_file_icon);
            tvType = itemView.findViewById(R.id.tv_type);
            llCard = itemView.findViewById(R.id.ll_card);
        }
    }

    class MsgToCardHolder extends RecyclerView.ViewHolder {

        TextView tvSendTime;
        RoundImageView ivHeader;
        TextView tvFileName;
        ImageView imgState;
        ImageView ivFileIcon;
        TextView tvType;
        ProgressBar progress;
        ImageView ivFailed;
        TextView tvRead;
        LinearLayout llCard;

        public MsgToCardHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            tvFileName = itemView.findViewById(R.id.tv_file_name);
            imgState = itemView.findViewById(R.id.img_state);
            ivFileIcon = itemView.findViewById(R.id.iv_file_icon);
            tvType = itemView.findViewById(R.id.tv_type);
            progress = itemView.findViewById(R.id.progress);
            ivFailed = itemView.findViewById(R.id.iv_failed);
            tvRead = itemView.findViewById(R.id.tv_read);
            llCard = itemView.findViewById(R.id.ll_card);
        }
    }

    class MsgFromVoiceHolder extends RecyclerView.ViewHolder {

        TextView tvSendTime;
        RoundImageView ivHeader;
        VoiceAnimView chatVoiceAnimView;
        ImageView imgState;

        public MsgFromVoiceHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            chatVoiceAnimView = itemView.findViewById(R.id.chat_voice);
            imgState = itemView.findViewById(R.id.img_state);
        }
    }

    class MsgToVoiceHolder extends RecyclerView.ViewHolder {

        TextView tvSendTime;
        RoundImageView ivHeader;
        VoiceAnimView chatVoiceAnimView;
        ImageView ivFailed;
        ProgressBar progress;
        TextView tvRead;


        public MsgToVoiceHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            chatVoiceAnimView = itemView.findViewById(R.id.chat_voice);
            progress = itemView.findViewById(R.id.progress);
            ivFailed = itemView.findViewById(R.id.iv_failed);
            tvRead = itemView.findViewById(R.id.tv_read);
        }
    }

    class MsgFromVolteCallHolder extends RecyclerView.ViewHolder {

        TextView tvSendTime;
        RoundImageView ivHeader;
        TextView chatText;

        public MsgFromVolteCallHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            chatText = itemView.findViewById(R.id.chat_text);
        }
    }

    class MsgToVolteCallHolder extends RecyclerView.ViewHolder {

        TextView tvSendTime;
        RoundImageView ivHeader;
        ProgressBar progress;
        ImageView ivFailed;
        TextView tvRead;
        TextView chatText;

        public MsgToVolteCallHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            progress = itemView.findViewById(R.id.progress);
            ivFailed = itemView.findViewById(R.id.iv_failed);
            tvRead = itemView.findViewById(R.id.tv_read);
            chatText = itemView.findViewById(R.id.chat_text);
        }
    }

    class MsgFromVideoCallHolder extends RecyclerView.ViewHolder {

        TextView tvSendTime;
        RoundImageView ivHeader;
        TextView chatText;

        public MsgFromVideoCallHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            chatText = itemView.findViewById(R.id.chat_text);
        }
    }

    class MsgToVideoCallHolder extends RecyclerView.ViewHolder {

        TextView tvSendTime;
        RoundImageView ivHeader;
        ProgressBar progress;
        ImageView ivFailed;
        TextView tvRead;
        TextView chatText;

        public MsgToVideoCallHolder(@NonNull View itemView) {
            super(itemView);
            tvSendTime = itemView.findViewById(R.id.tv_send_time);
            ivHeader = itemView.findViewById(R.id.iv_header);
            progress = itemView.findViewById(R.id.progress);
            ivFailed = itemView.findViewById(R.id.iv_failed);
            tvRead = itemView.findViewById(R.id.tv_read);
            chatText = itemView.findViewById(R.id.chat_text);
        }
    }

    private static String deleteHtml(String msg) {
        if (msg == null) {
            return "";
        }
        // msg = msg.replaceAll("<a href[^>]*>", "");
        // msg = msg.replaceAll("</a>", " ");
        // msg = msg.replaceAll("<img[^>]*/>", "");
        msg = msg.replaceAll("\n", "\r\n");
        return msg;
    }

    private void fillFileInco(MsgToCardHolder holder, ChatMessage bean) {
        if (bean.getFilePath().endsWith("mp3")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_y);
        } else if (bean.getFilePath().endsWith("mp4") || bean.getFilePath().endsWith("avi")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_v);
        } else if (bean.getFilePath().endsWith("xls")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_x);
        } else if (bean.getFilePath().endsWith("doc")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_w);
        } else if (bean.getFilePath().endsWith("ppt")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_p);
        } else if (bean.getFilePath().endsWith("pdf")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_f);
        } else if (bean.getFilePath().endsWith("apk")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_a);
        } else if (bean.getFilePath().endsWith("txt")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_t);
        } else if (bean.getFilePath().endsWith("rar") || bean.getFilePath().endsWith("zip")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_z);
        } else {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_what);
        }
    }

    private void fillFileInco(MsgFromCardHolder holder, ChatMessage bean) {
        if (bean.getContent().endsWith("mp3")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_y);
        } else if (bean.getContent().endsWith("mp4") || bean.getContent().endsWith("avi")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_v);
        } else if (bean.getContent().endsWith("xls")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_x);
        } else if (bean.getContent().endsWith("doc")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_w);
        } else if (bean.getContent().endsWith("ppt")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_p);
        } else if (bean.getContent().endsWith("pdf")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_f);
        } else if (bean.getContent().endsWith("apk")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_a);
        } else if (bean.getContent().endsWith("txt")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_t);
        } else if (bean.getContent().endsWith("rar") || bean.getContent().endsWith("zip")) {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_z);
        } else {
            holder.ivFileIcon.setImageResource(R.drawable.ic_muc_flie_type_what);
        }
    }


    /******
     * 处理显示的内容
     * @param content
     * @return
     */
    private String dealMessageContent(int time, String content) {
        if (time > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("聊天时长 ");

            int hours = time / 3600;
            if (hours > 0 && hours < 10) {
                builder.append("0").append(hours).append(":");
            } else if (hours > 10) {
                builder.append(hours).append(":");
            }

            int minuter = (time % 3600) / 60;
            if (minuter >= 0 && minuter < 10) {
                builder.append("0").append(minuter).append(":");
            } else if (minuter > 10) {
                builder.append(minuter).append(":");
            }

            int second = (time % 3600) % 60;
            if (second >= 0 && second < 10) {
                builder.append("0").append(second);
            } else if (second > 10) {
                builder.append(second);
            }

            return builder.toString();
        }
        return content;
    }

    private void showTime(TextView timeView, ChatMessage message) {
        if (messageList.indexOf(message) == 0) {
            timeView.setVisibility(View.VISIBLE);
            showTimeForm(timeView, message.getTimeSend());
//            timeView.setText(DateUtils.timestampToString1(message.getTimeSend()));
        } else {
            int position = messageList.indexOf(message);
            ChatMessage prev = messageList.get(position - 1);
            if (prev != null && message.getTimeSend() - prev.getTimeSend() > 300000) {
                timeView.setVisibility(View.VISIBLE);
//                timeView.setText(DateUtils.timestampToString1(message.getTimeSend()));
                showTimeForm(timeView, message.getTimeSend());
            } else {
                timeView.setVisibility(View.GONE);
            }
        }
    }


    /********
     * 日期显示的格式
     * @param view
     * @param time
     */
    private void showTimeForm(TextView view, long time) {
        // 判断是否是今天  是今天就显示上午/下午 + 时间
        // 判断是否是昨天的 ，是就显示昨天 +  时间
        // 判断是否这一周，如果是，就显示周几+时间
        // 判断是否这一年，如果是今年，就显示月-日  时：分
        // 显示年-月-日 时：分
        Date date = new Date(time);
        if (DateUtils.isToday(date)) { // 是否今天
            view.setText(DateUtils.getTodayTime(date));
        } else if (DateUtils.isYesterday(time)) {
            view.setText(DateUtils.getYesterdayTime(date));
        } else if (DateUtils.isThisYear(date)) {
            view.setText(DateUtils.timestampToString6(time));
        } else {
            view.setText(DateUtils.timestampToString1(time));
        }
    }
}
