package com.rv.im.adapter;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;


import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.im.R;
import com.rv.im.bean.ContactsBean;
import com.rv.im.util.sortlist.PingYinUtil;

import java.util.List;

public class AddressListAdapter extends BaseQuickAdapter<ContactsBean.ContactItemBean, BaseViewHolder> {


    private boolean needShowNavigation = true;

    private String lastNavigation = null;

    @Override
    public void setNewData(@Nullable List<ContactsBean.ContactItemBean> data) {
        lastNavigation = null;
        needShowNavigation = true;
        super.setNewData(data);
    }

    public AddressListAdapter(@Nullable List<ContactsBean.ContactItemBean> data) {
        super(R.layout.item_address_list, data);
    }

    public OnItemClickListener listener;

    public void setListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    @Override
    protected void convert(BaseViewHolder helper, ContactsBean.ContactItemBean item) {
        helper.setText(R.id.tv_name, item.getToNickname());

        if (item.getType() == 0) {
            helper.itemView.findViewById(R.id.ll_navigation).setVisibility(View.GONE);
            if (item.getLocalHead() != 0) {
                helper.setImageResource(R.id.img_header, item.getLocalHead());
            }
        } else {
            String navigation = PingYinUtil.getPingYin(item.getToNickname());
            if (!TextUtils.isEmpty(navigation) && navigation.substring(0, 1).equals(lastNavigation)) {
                needShowNavigation = false;
            } else {
                if (!TextUtils.isEmpty(navigation)) {
                    lastNavigation = navigation.substring(0, 1);
                }
                needShowNavigation = true;
            }

            if (needShowNavigation) {
                helper.itemView.findViewById(R.id.ll_navigation).setVisibility(View.VISIBLE);
                helper.setText(R.id.tv_character, TextUtils.isEmpty(lastNavigation) ? "" : lastNavigation);
            } else {
                helper.itemView.findViewById(R.id.ll_navigation).setVisibility(View.GONE);
                helper.setText(R.id.tv_character, TextUtils.isEmpty(lastNavigation) ? "" : lastNavigation);
            }
        }

        helper.itemView.setOnClickListener(v -> {
            if (listener != null) {
                listener.onItemclick(getData().indexOf(item), item);
            }
        });
    }


    public interface OnItemClickListener<T> {
        void onItemclick(int position, T t);
    }
}
