package com.rv.im.adapter;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;


import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.im.R;
import com.rv.im.db.table.Friend;

import java.util.List;

public class AddRecordListAdapter extends BaseQuickAdapter<Friend, BaseViewHolder> {

    private FriendItemClickListener listener;

    public AddRecordListAdapter(@Nullable List<Friend> data) {

        super(R.layout.item_add_record, data);
    }

    public void setListener(FriendItemClickListener listener) {
        this.listener = listener;
    }

    @Override
    protected void convert(BaseViewHolder helper, Friend item) {

        if (item == null) return;
        /********
         *   1 等待验证 ，添加成功
         *   2 同意，已同意，已拒绝
         */
        helper.setImageResource(R.id.img_header, R.drawable.icon_lion);
        helper.setText(R.id.tv_name, TextUtils.isEmpty(item.getUserName()) ? " " : item.getUserName());
        helper.setOnClickListener(R.id.ll_content, v -> {
            if (listener != null) {
                listener.showDetail(item);
            }
        });

        if (item.getStatus() == Friend.STATUS_10) {
            helper.itemView.findViewById(R.id.btn_add).setVisibility(View.GONE);
            helper.itemView.findViewById(R.id.text_add_status).setVisibility(View.VISIBLE);
            helper.setText(R.id.text_add_status, "等待验证");
        } else if (item.getStatus() == Friend.STATUS_11) {
            helper.itemView.findViewById(R.id.btn_add).setVisibility(View.VISIBLE);
            helper.itemView.findViewById(R.id.text_add_status).setVisibility(View.GONE);
            helper.setText(R.id.btn_add, "同意");
        } else if (item.getStatus() == Friend.STATUS_12) {
            helper.itemView.findViewById(R.id.btn_add).setVisibility(View.GONE);
            helper.itemView.findViewById(R.id.text_add_status).setVisibility(View.VISIBLE);
            helper.setText(R.id.text_add_status, "同意添加");
        } else if (item.getStatus() == Friend.STATUS_13) {
            helper.itemView.findViewById(R.id.btn_add).setVisibility(View.GONE);
            helper.itemView.findViewById(R.id.text_add_status).setVisibility(View.VISIBLE);
            helper.setText(R.id.text_add_status, "验证通过");
        } else if (item.getStatus() == Friend.STATUS_21 || item.getStatus() == Friend.STATUS_22) {
            helper.itemView.findViewById(R.id.btn_add).setVisibility(View.GONE);
            helper.itemView.findViewById(R.id.text_add_status).setVisibility(View.VISIBLE);
            helper.setText(R.id.text_add_status, item.getAction());
        }

        helper.setOnClickListener(R.id.btn_add, v -> {
            if (listener != null) {
                listener.agree(item);
            }
        });
    }


    public interface FriendItemClickListener {

        void showDetail(Friend item);

        void agree(Friend item);
    }
}
