package com.rv.im;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.im.bean.UserDetailBean;
import com.rv.im.friend.RealAddFriendActivity;
import com.rv.im.listener.NoDoubleClickListener;
import com.rv.im.presenter.UserDetailPresenter;
import com.rv.im.util.DateUtils;
import com.rv.im.util.TimeUtils;
import com.rv.im.view.RoundImageView;

public class UserDetailActivity extends BaseStatusActivity<UserDetailPresenter> {

    private static final String KEY_USER_ID = "userId";
    private static final String KEY_ADD_TYPE = "addType";

    private String userId;
    private int fromAddType;

    private String mLoginUserId;

    private RoundImageView avatarImg;
    private TextView nameTv;
    private TextView renameTv;
    private TextView sexTv;
    private TextView birthdayTv;
    private TextView cityText;
    private TextView phoneTv;
    private TextView onlineTv;

    private Button btnNextStep;

    private UserDetailBean.UserDetail user;

    public static void start(Context ctx, String userId) {
        Intent intent = new Intent(ctx, UserDetailActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString(KEY_USER_ID, userId);
        intent.putExtras(bundle);
        ctx.startActivity(intent);
    }

    public static void start(Context ctx, String userId, int fromAddType) {
        Intent intent = new Intent(ctx, UserDetailActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString(KEY_USER_ID, userId);
        bundle.putInt(KEY_ADD_TYPE, fromAddType);
        intent.putExtras(bundle);
        ctx.startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_user_detail;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("基本信息");
        initWidget();
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        if (intent != null) {
            userId = intent.getStringExtra(KEY_USER_ID);
            fromAddType = intent.getIntExtra(KEY_ADD_TYPE, -1) ;
        }
        mLoginUserId = ImSetting.getUserId();
        if (TextUtils.isEmpty(userId)) {
            userId = mLoginUserId;
        }
        mPresenter.loadOtherInfoFromNet(userId);
    }

    private void initWidget() {
        nameTv = findViewById(R.id.name_tv);
        avatarImg = findViewById(R.id.avatar_img);
        renameTv = findViewById(R.id.rename_tv);
        sexTv = findViewById(R.id.sex_tv);
        birthdayTv = findViewById(R.id.birthday_tv);
        cityText = findViewById(R.id.city_text);
        phoneTv = findViewById(R.id.phone_tv);
        onlineTv = findViewById(R.id.online_tv);
        btnNextStep = findViewById(R.id.next_step_btn);
    }


    @Override
    public void onShowResult(int requestType, BaseBean result) {

        switch (requestType) {
            case 0:
                if (result != null && result.resultCode == 1) {
                    UserDetailBean userDetailBean = (UserDetailBean) result;
                    user = userDetailBean.getData();
                    updateUi();
                }
                break;
        }
    }

    private void updateUi() {
        if (user == null) {
            return;
        }
        if (isFinishing()) {
            return;
        }

        nameTv.setText(TextUtils.isEmpty(user.getNickName()) ? "" : user.getNickName());
        birthdayTv.setText(DateUtils.timestampToString2(user.getBirthday() * 1000));
        sexTv.setText(user.getSex() == 0 ? "女" : "男");
//        cityText.setText();
        if (TextUtils.isEmpty(user.getPhone())) {
            ((View) (phoneTv.getParent())).setVisibility(View.GONE);
        } else {
            ((View) (phoneTv.getParent())).setVisibility(View.VISIBLE);
            phoneTv.setText(user.getPhone());
        }

        if (user.getShowLastLoginTime() > 0) {
            ((View) (onlineTv.getParent())).setVisibility(View.VISIBLE);
            onlineTv.setText(TimeUtils.getFriendlyTimeDesc(this, user.getShowLastLoginTime()));
        } else {
            ((View) (onlineTv.getParent())).setVisibility(View.GONE);
        }

        if (userId == mLoginUserId) {
            btnNextStep.setVisibility(View.GONE);
        } else {
            btnNextStep.setVisibility(View.VISIBLE);
            if (user.getFriends() == null) {// 陌生人
                btnNextStep.setText("添加好友");
                btnNextStep.setOnClickListener(new AddAttentionListener());
            } else if (user.getFriends().getBlacklist() == 1) {  //  需显示移除黑名单

                btnNextStep.setText("移除黑名单");
//                btnNextStep.setOnClickListener(new RemoveBlacklistListener());
            } else if (user.getFriends().getIsBeenBlack() == 1) {//  需显示加入黑名单
                btnNextStep.setText("加入黑名单");
            } else if (user.getFriends().getStatus() == 2 || user.getFriends().getStatus() == 4) {// 好友
                btnNextStep.setText("发送消息");
                btnNextStep.setOnClickListener(new SendMsgListener());
            } else {
                btnNextStep.setText("添加好友");
                btnNextStep.setOnClickListener(new AddAttentionListener());
            }
        }
    }

    private class SendMsgListener extends NoDoubleClickListener {

        @Override
        public void onNoDoubleClick(View view) {
            Intent intent = ChatActivity.getIntent(UserDetailActivity.this, userId, user.getNickName(), 0);
            startActivity(intent);
            finish();
        }
    }

    public class AddAttentionListener extends NoDoubleClickListener {
        @Override
        public void onNoDoubleClick(View view) {
            Intent intent = RealAddFriendActivity.getIntent(getApplicationContext(), userId, user.getNickName(), fromAddType);
            startActivity(intent);
            finish();
        }
    }
}
