package com.rv.im;

import android.text.TextUtils;

import com.rv.im.db.table.ChatMessage;
import com.rv.im.enums.MessageTypeEnum;

public class ChatHolderFactory {

    public static int getChatHolderType(String mLoginUserId, ChatMessage message) {
        ChatHolderTypeEnum type = null;
        if (message != null && !TextUtils.isEmpty(mLoginUserId)) {
            if (message.getMessageType() == MessageTypeEnum.TEXT.getType()) {
                if (mLoginUserId.equals(message.getFromUserId())) {
                    type = ChatHolderTypeEnum.VIEW_TO_TEXT;
                } else {
                    type = ChatHolderTypeEnum.VIEW_FROM_TEXT;
                }
            } else if (message.getMessageType() == MessageTypeEnum.FILE.getType()) {
                if (mLoginUserId.equals(message.getFromUserId())) {
                    type = ChatHolderTypeEnum.VIEW_TO_FILE;
                } else {
                    type = ChatHolderTypeEnum.VIEW_FROM_FILE;
                }
            } else if (message.getMessageType() == MessageTypeEnum.PIC.getType()) {
                if (mLoginUserId.equals(message.getFromUserId())) {
                    type = ChatHolderTypeEnum.VIEW_TO_IMAGE;
                } else {
                    type = ChatHolderTypeEnum.VIEW_FROM_IMAGE;
                }
            } else if (message.getMessageType() == MessageTypeEnum.VOICE.getType()) {
                if (mLoginUserId.equals(message.getFromUserId())) {
                    type = ChatHolderTypeEnum.VIEW_TO_VOICE;
                } else {
                    type = ChatHolderTypeEnum.VIEW_FROM_VOICE;
                }
            } else if (message.getMessageType() == MessageTypeEnum.VOLTE_CALL.getType()) {
                if (mLoginUserId.equals(message.getFromUserId())) {
                    type = ChatHolderTypeEnum.VIEW_TO_VOLTE;
                } else {
                    type = ChatHolderTypeEnum.VIEW_FROM_VOLTE;
                }
            } else if (message.getMessageType() == MessageTypeEnum.VIDEO_CALL.getType()) {
                if (mLoginUserId.equals(message.getFromUserId())) {
                    type = ChatHolderTypeEnum.VIEW_TO_VIDEO;
                } else {
                    type = ChatHolderTypeEnum.VIEW_FROM_VIDEO;
                }
            } else if (message.getMessageType() == MessageTypeEnum.PASS.getType()) {
                if (mLoginUserId.equals(message.getToUserId())) { // 对方同意我的添加好友
                    type = ChatHolderTypeEnum.VIEW_BE_PASS;
                } else {  // 我同意对方的添加好友
                    type = ChatHolderTypeEnum.VIEW_PASS;
                }
            } else if (message.getMessageType() == MessageTypeEnum.BE_FRIEND.getType()) {
                if (mLoginUserId.equals(message.getToUserId())) { // 对方直接添加我为好友
                    type = ChatHolderTypeEnum.VIEW_BE_FRIEND;
                } else {  // 我直接添加对方为好友
                    type = ChatHolderTypeEnum.VIEW_ADD_SUCCESS;
                }
            }
        }
        if (type != null)
            return type.getId();
        return 0;
    }

}
