package com.rv.im;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.widget.LinearLayout;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.RvCache;
import com.rv.im.adapter.AddressListAdapter;
import com.rv.im.bean.ContactsBean;
import com.rv.im.db.table.ChatMessage;
import com.rv.im.friend.NewFriendActivity;
import com.rv.im.presenter.AddressPresenter;
import com.rv.im.util.sortlist.PingYinUtil;
import com.rv.im.xmpp.ListenerManager;
import com.rv.im.xmpp.listener.NewFriendListener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

/************
 *
 * 通讯录
 *
 */
public class AddressListActivity extends BaseStatusActivity<AddressPresenter> implements NewFriendListener {

    private RecyclerView recyclerView;

    private AddressListAdapter adapter = null;

    private List<ContactsBean.ContactItemBean> lists = new LinkedList<>();


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ListenerManager.getInstance().addNewFriendListener(this);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        ListenerManager.getInstance().removeNewFriendListener(this);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_address_list;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle(getString(R.string.title_address_list));
        recyclerView = findViewById(R.id.recyclerview);
        recyclerView.setLayoutManager(new LinearLayoutManager(this, LinearLayout.VERTICAL, false));
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        mPresenter.initAddress(lists);
        adapter = new AddressListAdapter(lists);
        adapter.setListener((AddressListAdapter.OnItemClickListener<ContactsBean.ContactItemBean>) (position, bean) -> {
            Intent in;
            if (position == 0) {
                in = new Intent(AddressListActivity.this, CustomerListActivity.class);
                startActivityForResult(in, 1000);
            } else if (position == 1) {

            } else if (position == 2) {
                in = new Intent(AddressListActivity.this, NewFriendActivity.class);
                startActivity(in);
            } else {
                in = ChatActivity.getIntent(this, bean.getToUserId(), bean.getToNickname(), 0);
                startActivity(in);
            }
        });
        recyclerView.setAdapter(adapter);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                if (result != null && result instanceof ContactsBean) {
                    ContactsBean bean = (ContactsBean) result;
                    if (bean.resultCode == 1) {
                        RvCache.getInstance().save(bean, CacheEnum.CONTACTS);
                        if (bean.getData() != null && bean.getData().size() > 0) {
                            // 保存数据，更新ui;
                            lists.clear();
                            lists.addAll(bean.getData());
                            Collections.sort(lists, (o1, o2) -> {
                                if(TextUtils.isEmpty(o1.getToNickname())){
                                    return 1;
                                }
                                if(TextUtils.isEmpty(o2.getToNickname())){
                                    return -1;
                                }
                                String pingyin = PingYinUtil.getPingYin(o2.getToNickname());
                                String pingy = PingYinUtil.getPingYin(o1.getToNickname());
                                if (!TextUtils.isEmpty(pingy) && !TextUtils.isEmpty(pingyin)) {
                                    return pingy.compareTo(pingyin);
                                }
                                return 0;
                            });
                            mPresenter.addTopDatas(lists);
                            adapter.setNewData(lists);
                        }
                    }
                }
                break;
            default:
                break;
        }
    }

    @Override
    public void onNewFriendSendStateChange(String toUserId, ChatMessage message, int messageState) {
        //
    }

    @Override
    public boolean onNewFriend(ChatMessage message) {
        return false;
    }
}
