package com.xxrv.coupon.adapter;

import android.text.TextUtils;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.component.utils.DateUtils;
import com.xxrv.coupon.R;
import com.xxrv.coupon.bean.CouponBean;

/**
 * 优惠券 待使用
 */

public class WaitCouponAdapter extends BaseQuickAdapter<CouponBean.DataBean, BaseViewHolder> {

    public WaitCouponAdapter() {
        super(R.layout.rv_item_waitcoupon);
    }

    @Override
    protected void convert(BaseViewHolder helper, CouponBean.DataBean item) {
        if (item != null) {
            helper.setText(R.id.tv_name, item.getTitle());
            helper.setText(R.id.tv_type, item.getSubtitle());
            if (!TextUtils.isEmpty(item.getExpireDate()))
                helper.setText(R.id.tv_date, item.getExpireDate());
            helper.setText(R.id.tv_amount, String.valueOf(item.getUsedAmount()));
            if ("1".equals(item.getType())) {  //1满减券 2叠加满减券 3无门槛券
                helper.setText(R.id.tv_condition, "满" + item.getWithAmount() + "减" + item.getUsedAmount() + "元");
            } else if ("3".equals(item.getType())) {
                helper.setText(R.id.tv_condition, "无门槛");
            }
        }
    }
}
