package com.xxrv.carpurchase.adapter;

import android.text.TextUtils;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.view.StarBar;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.ruiwenliu.wrapper.util.TransformationUtil2;
import com.ruiwenliu.wrapper.util.glide.GlideApp;
import com.ruiwenliu.wrapper.util.glide.GlideOptions;
import com.rv.component.utils.DisplayUtil;
import com.xxrv.carpurchase.R;
import com.xxrv.carpurchase.beam.CarPurChaseListBean;

/**
 * 购房车功能列表
 */

public class CarPurChaseListAdapter extends BaseQuickAdapter<CarPurChaseListBean.DataBeanX.DataBean, BaseGlideHolder> {
    public CarPurChaseListAdapter() {
        super(R.layout.rv_item_car_purchase_list);
    }

    @Override
    protected void convert(BaseGlideHolder helper, CarPurChaseListBean.DataBeanX.DataBean item) {

//        helper.loadImage(mContext, item.getIcon(), (ImageView) helper.getView(R.id.iv_goods));


        String icon ="";
        if (!TextUtils.isEmpty(item.getCoverPic())){
            icon = item.getCoverPic();
        }else {
            icon = item.getIcon();
        }
        helper.loadRoundImage(mContext, icon, (ImageView) helper.getView(R.id.iv_goods), 10, DisplayUtil.dip2px(mContext,  helper.getView(R.id.iv_goods).getWidth()), DisplayUtil.dip2px(mContext, helper.getView(R.id.iv_goods).getHeight()));

        helper.setText(R.id.tv_name, item.getName());
        helper.setText(R.id.tv_context, item.getKeyword());
        float score = (float) item.getScore() / 10;
        StarBar starBar = helper.getView(R.id.starbar1);
        starBar.setStarMark(score);
        helper.setText(R.id.tv_point, score + "分");
        helper.setText(R.id.tv_price, "¥"+ item.getBuyPrice());
    }
}
