package com.rv.tourism.dialog;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.dialog.BaseDialog;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.rv.component.utils.DateUtils;
import com.rv.component.utils.DisplayUtil;
import com.rv.tourism.R;
import com.rv.tourism.adapter.TravelBookingDepartureAdapter;
import com.rv.tourism.adapter.TravelBookingDeparturetimeAdapter;
import com.rv.tourism.bean.BeanOrderParam;
import com.rv.tourism.bean.BeanTourDetailData;

import java.util.List;


/**
 * 旅游预定弹框
 */

public class TravelBookingDialog extends BaseDialog {

    private TravelBookingDepartureAdapter mAdapter;
    private TravelBookingDeparturetimeAdapter mTimeAdapter;
    private int adufe = 1;
    private int chile = 0;
    private TextView adultPrice;
    private TextView childPrice;
    private OnOKClickListener listener;
    private BeanTourDetailData.DataBeanX.TourDepartTimeVo tourDepartTimeVo;
    private BeanTourDetailData.DataBeanX.TourDepartVo tourDepartVo;
    private BeanTourDetailData.DataBeanX bean;

    public TravelBookingDialog(@NonNull Context context) {
        super(context);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, DisplayUtil.dip2px(context, 450), Gravity.BOTTOM);
    }

    @Override
    public void helper(ViewHolder helper) {
        super.helper(helper);

        RecyclerView rcDeparturetime = helper.getView(R.id.rc_departuretime);
        RecyclerView rcDeparture = helper.getView(R.id.rc_departure);
        adultPrice = helper.getView(R.id.tv_adult_price);
        childPrice = helper.getView(R.id.tv_child_price);

        mAdapter = new TravelBookingDepartureAdapter();
        rcDeparture.setLayoutManager(new LinearLayoutManager(getDialogContext()));
        rcDeparture.setNestedScrollingEnabled(false);
        rcDeparture.setAdapter(mAdapter);

        mTimeAdapter = new TravelBookingDeparturetimeAdapter();
        rcDeparturetime.setLayoutManager(new LinearLayoutManager(getDialogContext()));
        rcDeparturetime.setNestedScrollingEnabled(false);
        rcDeparturetime.setAdapter(mTimeAdapter);

        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapters, View view, int position) {
                tourDepartVo = (BeanTourDetailData.DataBeanX.TourDepartVo) adapters.getItem(position);
                mAdapter.setSelectPosition(position);
            }
        });

        mTimeAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                BeanTourDetailData.DataBeanX.TourDepartTimeVo item = (BeanTourDetailData.DataBeanX.TourDepartTimeVo) adapter.getItem(position);
                if ("0".equals(item.getOverdue())) {
                    tourDepartTimeVo = item;
                    mTimeAdapter.setSelectPosition(position);
                }
            }
        });

        initOnclick(helper);

    }

    private void initOnclick(final ViewHolder helper) {
        helper.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int id = v.getId();
                if (id == R.id.iv_close) {
                    dismiss();

                } else if (id == R.id.tv_item_booking_adult_less) {
                    if (adufe > 0) {
                        adufe--;
                        helper.setText(R.id.tv_booking_adult, String.valueOf(adufe));
                    }

                } else if (id == R.id.tv_item_booking_adult_add) {
                    adufe++;
                    helper.setText(R.id.tv_booking_adult, String.valueOf(adufe));

                } else if (id == R.id.tv_item_booking_child_less) {
                    if (chile > 0) {
                        chile--;
                        helper.setText(R.id.tv_booking_child, String.valueOf(chile));
                    }

                } else if (id == R.id.tv_item_booking_child_add) {
                    chile++;
                    helper.setText(R.id.tv_booking_child, String.valueOf(chile));

                } else if (id == R.id.tv_travel_booking_ok) {
                    if (adufe < chile) {
                        Toast.makeText(getContext(), "成人出游人数要大于或等于儿童出游人数", Toast.LENGTH_SHORT).show();
                        return;
                    }

                    if (adufe == 0) {
                        Toast.makeText(getContext(), "成人出游人数不能为空！", Toast.LENGTH_SHORT).show();
                        return;
                    }

                    List<BeanTourDetailData.DataBeanX.TourDepartVo> endDeparture = bean.getEndDeparture();
                    if (listener != null && bean != null && endDeparture != null && tourDepartTimeVo != null && tourDepartVo != null) {
                        BeanOrderParam beanOrderParam = new BeanOrderParam();
                        beanOrderParam.setEndTime(tourDepartTimeVo.getEndTime() + " " + DateUtils.secToTime(tourDepartVo.getDepartTime()));
                        beanOrderParam.setGoodId(bean.getId());
                        beanOrderParam.setPrice(bean.getPrice());
                        beanOrderParam.setChildPrice(bean.getChildPrice());
                        beanOrderParam.setSpePriceId(tourDepartTimeVo.getId());
                        beanOrderParam.setAdultNum(String.valueOf(adufe));
                        beanOrderParam.setChildNum(String.valueOf(chile));
                        String time = tourDepartTimeVo.getStartTime() + getWeek(tourDepartTimeVo.getStartWeek()) + "~" + tourDepartTimeVo.getEndTime() + getWeek(tourDepartTimeVo.getEndWeek());
                        beanOrderParam.setTime(time);

                        beanOrderParam.setEndAddr(endDeparture.get(0).getAddress());
                        beanOrderParam.setStartAddr(tourDepartVo.getProvinceName() + tourDepartVo.getCityName() + tourDepartVo.getAddress());
                        beanOrderParam.setStartTime(tourDepartTimeVo.getStartTime() + " " + DateUtils.secToTime(tourDepartVo.getDepartTime()));
                        beanOrderParam.setStartCompanyId(tourDepartVo.getCompanyId());
                        beanOrderParam.setStartCompanyName(tourDepartVo.getName());
                        beanOrderParam.setSiteId(tourDepartVo.getId());
                        listener.onClickData(beanOrderParam);
                    }
                    dismiss();
                }
            }
        }, R.id.iv_close, R.id.tv_item_booking_adult_less, R.id.tv_item_booking_adult_add, R.id.tv_item_booking_child_less, R.id.tv_item_booking_child_add, R.id.tv_travel_booking_ok);
    }

    public void setNewData(BeanTourDetailData.DataBeanX bean) {
        this.bean = bean;
        if (mAdapter != null && mTimeAdapter != null && bean != null) {
            mAdapter.setNewData(bean.getDeparture());
            mTimeAdapter.setNewData(bean.getTourDepartTimeVo());
        }

        if (adultPrice != null && childPrice != null && bean != null) {
            adultPrice.setText("成人：¥" + bean.getPrice() + "/人");
            childPrice.setText("儿童：¥" + bean.getChildPrice() + "/人");
        }

        if (bean != null && bean.getDeparture() != null && bean.getDeparture().size() > 0) {
            tourDepartVo = bean.getDeparture().get(0);
        }

        if (bean != null && bean.getTourDepartTimeVo() != null && bean.getTourDepartTimeVo().size() > 0) {
            for (int i = 0; i < bean.getTourDepartTimeVo().size(); i++) {
                if ("0".equals(bean.getTourDepartTimeVo().get(i).getOverdue())) {
                    tourDepartTimeVo = bean.getTourDepartTimeVo().get(i);
                    mTimeAdapter.setSelectPosition(i);
                    break;
                }
            }
        }
    }

    @Override
    public int getViewLayout() {
        return R.layout.dialog_travel_booking;
    }

    public void setOnDayClickListener(OnOKClickListener listener) {
        this.listener = listener;
    }

    public interface OnOKClickListener {
        void onClickData(BeanOrderParam data);
    }


    public String getWeek(int no) {
        String week = "";
        switch (no) {
            case 0:
                week = "周日";
                break;
            case 1:
                week = "周一";
                break;
            case 2:
                week = "周二";
                break;
            case 3:
                week = "周三";
                break;
            case 4:
                week = "周四";
                break;
            case 5:
                week = "周五";
                break;
            case 6:
                week = "周六";
                break;
        }
        return week;
    }
}
