package com.rv.home.rv.module.ui.main.home.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.component.utils.DateUtils;
import com.rv.home.R;
import com.rv.home.rv.module.ui.main.home.bean.CarRentalPriceBean;
import com.rv.home.rv.module.ui.main.home.bean.SearchBean;

/**
 * 租车价格查看
 */

public class CarRentalCheckPriceAdapter extends BaseQuickAdapter<CarRentalPriceBean.DataBean, BaseViewHolder> {
    private boolean type;

    public CarRentalCheckPriceAdapter() {
        super(R.layout.rv_item_carrental_check_price);
    }

    @Override
    protected void convert(BaseViewHolder helper, CarRentalPriceBean.DataBean item) {
        helper.setText(R.id.tv_date, DateUtils.formatDate24(item.getDate()));

        if (item.getSelect()) {
            helper.setBackgroundColor(R.id.ll_item_bg, mContext.getResources().getColor(R.color.gray_FFF3E2));
        } else {
            helper.setBackgroundColor(R.id.ll_item_bg, mContext.getResources().getColor(R.color.colorWrite));
        }

        if (type) {
            helper.setText(R.id.tv_price, item.getFreeDays());
        } else {
            helper.setText(R.id.tv_price, "¥" + item.getPrice());
        }

    }

    public void setType(boolean type) {
        this.type = type;
    }
}
