package com.xxfc.discovery.dialog;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;

import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.dialog.BaseDialog;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.rv.component.utils.DisplayUtil;
import com.xxfc.discovery.R;
import com.xxfc.discovery.adapter.DiscoveryVideoCommentAdapter;
import com.xxfc.discovery.api.DiscoveryApi;
import com.xxfc.discovery.bean.DiscoveryIMTokenBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;


/**
 * 视频评论
 */

public class DiscoveryVideoDialog extends BaseDialog {

    private final Context context;
    private DiscoveryVideoCommentAdapter commentAdapter;


    public DiscoveryVideoDialog(@NonNull Context context) {
        super(context);
        this.context = context;
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, DisplayUtil.dip2px(context, 450), Gravity.BOTTOM);
    }

    @Override
    public void helper(ViewHolder helper) {
        super.helper(helper);

        RecyclerView recyclerView = helper.getView(R.id.rv_video_comment);
        commentAdapter = new DiscoveryVideoCommentAdapter();
        recyclerView.setLayoutManager(new LinearLayoutManager(getDialogContext()));
        recyclerView.setNestedScrollingEnabled(false);
        recyclerView.setAdapter(commentAdapter);


        helper.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                TrillCommentInputDialog trillCommentInputDialog = new TrillCommentInputDialog(context, new TrillCommentInputDialog.OnSendCommentListener() {
                    @Override
                    public void sendComment(String str) {

                    }
                });
                Window window = trillCommentInputDialog.getWindow();
                if (window != null) {
                    window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_VISIBLE);// 软键盘弹起
                    trillCommentInputDialog.show();
                }
            }
        }, R.id.ll_item_comment);


        helper.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        }, R.id.iv_close);

    }



    @Override
    public int getViewLayout() {
        return R.layout.dialog_discovery_video;
    }

}
