package com.rv.component.utils;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.RequiresApi;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.UUID;

/**
 * 工具类
 */
public class Inc {


    /**
     * 线程睡眠
     */
    public static void sleep(long time) {
        try {
            Thread.sleep(time);
        } catch (Exception e) {
        }
    }

    /**
     * 对没有冒号分隔符的MAC地址加上：
     *
     * @param mac
     * @return
     */
    public static String macAddFix(String mac) {

        String newMac = "";
        try {
            for (int i = 0; i < mac.length(); i = i + 2) {
                newMac = newMac + mac.substring(i, i + 2) + ":";
            }
            if (newMac.length() > 0) {
                newMac = newMac.substring(0, newMac.length() - 1);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return newMac;
    }

    private static long lastClickTime;

    /**
     * 防止按钮频繁点击
     *
     * @return true为是。 如果是在500ms内有点击过就返回true
     */
    public synchronized static boolean isFastClick() {
        long time = System.currentTimeMillis();
        if (time - lastClickTime < 500) {
            return true;
        }
        lastClickTime = time;
        return false;
    }


    /**
     * 将数字转换成两位小数字符串
     *
     * @param price
     * @return
     */
    public static String covertNumToStr(Number price) {
        String str = "";
        try {
            DecimalFormat df = new DecimalFormat("0.00");//格式化小数
            str = df.format(price);//返回的是String类型
        } catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    /**
     * 获取手机设备名称
     *
     * @return
     */
    public static String getDeviceName() {
        String deviceName = "";
        try {
            deviceName = android.os.Build.MODEL;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return deviceName;
    }

    /**
     * 获取Android版本 6.0
     *
     * @return
     */
    public static String getReleaseVersion() {
        String releaseVersion = "";
        try {
            releaseVersion = Build.VERSION.RELEASE;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return releaseVersion;
    }

    /**
     * 获取版本号 23
     *
     * @return
     */
    public static String getSdkVersion() {
        String sdkVersion = "";
        try {
            sdkVersion = String.valueOf(Build.VERSION.SDK_INT);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return sdkVersion;
    }

    /**
     * 获取显示屏参数
     *
     * @return
     */
    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR1)
    public static String getDeviceDisplay(Activity activity) {
        String deviceDisplay = "";
        try {
            //deviceDisplay = Build.DISPLAY;
            DisplayMetrics metrics = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getRealMetrics(metrics);
            deviceDisplay = metrics.widthPixels + "*" + metrics.heightPixels;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return deviceDisplay;
    }

    /**
     * 获取手机制造商
     *
     * @return
     */
    public static String getDeviceProduct() {
        String deviceProduct = "";
        try {
            //deviceProduct= Build.PRODUCT;
            deviceProduct = Build.MANUFACTURER;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return deviceProduct;
    }

    /**
     * 获取手机MAC
     *
     * @return
     */
    public static String getMacAddress(Context context) {
        String macAddress = "";
        WifiManager wifi = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        WifiInfo info = wifi.getConnectionInfo();
        String wifiMac = info.getMacAddress();
        if (!TextUtils.isEmpty(wifiMac) && !wifiMac.equals("02:00:00:00:00:00")) {
            macAddress = wifiMac;
        }
        return macAddress;
    }


    /**
     * 判断是否存在SD卡
     *
     * @return
     */
    public static boolean existSDCard() {
        if (android.os.Environment.getExternalStorageState().equals(
                android.os.Environment.MEDIA_MOUNTED)) {
            return true;
        } else
            return false;
    }

    /**
     * 将yyMMddHHmm两两拆分
     *
     * @param date
     * @return yy  MM  dd  HH  mm
     */
    public static byte[] splitDate(String date) {
        byte[] time = new byte[5];
        try {
            for (int i = 0; i < time.length; i++) {
                String temp = date.substring(i * 2, i * 2 + 2);
                time[i] = (byte) Integer.parseInt(temp);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }


    /**
     * 获取程序版本号
     *
     * @return
     */
    public static String getAppVersion(Context context) {
        String version = "";
        PackageManager manager = null;
        PackageInfo info = null;
        manager = context.getPackageManager();
        try {
            info = manager.getPackageInfo(context.getPackageName(), 0);
            version = info.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return version;
    }


    /**
     * 将图片转换成Base64编码的字符串
     */
    public static String imageToBase64(String path) {
        if (TextUtils.isEmpty(path)) {
            return null;
        }
        InputStream is = null;
        byte[] data = null;
        String result = null;
        try {
            is = new FileInputStream(path);
            //创建一个字符流大小的数组。
            data = new byte[is.available()];
            //写入数组
            is.read(data);
            //用默认的编码格式进行编码
            result = Base64.encodeToString(data, Base64.DEFAULT);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (null != is) {
                try {
                    is.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

        }
        return result;
    }


    /**
     * 手机号用****号隐藏中间数字
     *
     * @param str 手机号码
     * @return
     */
    public static String settingphone(String str) {
        String phone = str.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
        return phone;
    }


    /**
     * 邮箱用****号隐藏前面的字母
     *
     * @param email 邮箱账号
     * @return
     */
    public static String settingemail(String email) {
        String emails = email.replaceAll("(\\w?)(\\w+)(\\w)(@\\w+\\.[a-z]+(\\.[a-z]+)?)", "$1****$3$4");
        return emails;
    }

    /**
     * 身份证号用****号隐藏前面的字母
     *
     * @param idCard 身份证号
     * @return
     */
    public static String settingID(String idCard) {
        String idCardHide = idCard.replaceAll("(\\d{4})\\d{10}(\\w{4})", "$1********$2");
        return idCardHide;
    }

    /********
     * 设置程序不在前端的特殊情况
     * @param b
     */
    public static void setIsSpecialCases(boolean b) {
        Class<?> threadClazz = null;
        try {
            threadClazz = Class.forName("com.xxfc.rv.other.RvActivityLifecycleCallbacks");
            Method method = threadClazz.getMethod("setIsSpecialCases", Boolean.class);
            method.invoke(null, b);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
